#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

PROJECT_TYPE := module
PROJECT_VCPROJ := XRenderD3D10.vcproj

-include $(PROJECT_CODE)/Project_override.mk

PROJECT_CPPFLAGS_COMMON += \
	-I$(CODE_ROOT)/CryEngine/CryCommon \
	-I$(PROJECT_CODE)/.. \
	-I$(PROJECT_BUILD)/.. \
	-I$(CODE_ROOT)/SDKs/CRIMW/PS3/Include \
	-D_RENDERER -DUSE_SPURS
	
ifeq ($(ARCH),PS3-cell)
  PROJECT_CPPFLAGS_COMMON += \
	  -DXRENDERD3D10_EXPORTS -DDIRECT3D10 -DCRY_USE_GCM
	ifeq ($(MKOPTION_SNC),1)
	  PROJECT_CPPFLAGS_COMMON += --diag_suppress=376 --diag_suppress=68 --diag_suppress=109\
	   --diag_suppress=552	--diag_suppress=178 --diag_suppress=1067\
	   --diag_suppress=175 --diag_suppress=1646
	endif
  PROJECT_LDLIBS := -lpthread -lcgc
  ifeq ($(OPTION_PS3_GCMHUD),1)
    PROJECT_LDLIBS += -lgcm_hud -lgcm_pm 
  else
    PROJECT_LDLIBS += -lgcm_cmd -lgcm_sys_stub
  endif
#  PROJECT_LDLIBS += -lgcm_cmd -lgcm_sys_stub
  PROJECT_LDLIBS += -lm_stub -lfs_stub -lnet_stub -lsysutil_stub
endif # ARCH == PS3-cell

PROJECT_SOURCES_CPP_REMOVE := ../StdAfx.cpp \
 ../Common/Textures/Image/jpeg6/jcomapi.cpp \
 ../Common/Textures/Image/jpeg6/jdapimin.cpp \
 ../Common/Textures/Image/jpeg6/jdapistd.cpp \
 ../Common/Textures/Image/jpeg6/jdatasrc.cpp \
 ../Common/Textures/Image/jpeg6/jdcoefct.cpp \
 ../Common/Textures/Image/jpeg6/jdcolor.cpp \
 ../Common/Textures/Image/jpeg6/jddctmgr.cpp \
 ../Common/Textures/Image/jpeg6/jdhuff.cpp \
 ../Common/Textures/Image/jpeg6/jdinput.cpp \
 ../Common/Textures/Image/jpeg6/jdmainct.cpp \
 ../Common/Textures/Image/jpeg6/jdmarker.cpp \
 ../Common/Textures/Image/jpeg6/jdmaster.cpp \
 ../Common/Textures/Image/jpeg6/jdpostct.cpp \
 ../Common/Textures/Image/jpeg6/jdsample.cpp \
 ../Common/Textures/Image/jpeg6/jdtrans.cpp \
 ../Common/Textures/Image/jpeg6/jerror.cpp \
 ../Common/Textures/Image/jpeg6/jfdctflt.cpp \
 ../Common/Textures/Image/jpeg6/jidctflt.cpp \
 ../Common/Textures/Image/jpeg6/jmemmgr.cpp \
 ../Common/Textures/Image/jpeg6/jmemnobs.cpp \
 ../Common/Textures/Image/jpeg6/jutils.cpp \
 ../Common/Textures/Image/JpgImage.cpp \
 ../Common/Textures/Image/TgaImage.cpp \
 ../Common/Textures/Image/Squish/alpha.cpp \
 ../Common/Textures/Image/Squish/clusterfit.cpp \
 ../Common/Textures/Image/Squish/colourblock.cpp \
 ../Common/Textures/Image/Squish/colourfit.cpp \
 ../Common/Textures/Image/Squish/colourset.cpp \
 ../Common/Textures/Image/Squish/maths.cpp \
 ../Common/Textures/Image/Squish/rangefit.cpp \
 ../Common/Textures/Image/Squish/singlecolourfit.cpp \
  ../Common/Textures/Image/Squish/squish.cpp

ifeq ($(OPTION_PROFILE),1)
  PROJECT_XFLAGS += -O2 $(PS3_MATHOPT)
  PROJECT_XFLAGS_DXPS_Device_CCryDXPSRenderDevice_cpp := -O3 -fno-schedule-insns2 -fno-schedule-insns $(PS3_MATHOPT)
endif

ifeq ($(MKOPTION_UNITYBUILD),1)
PROJECT_SOURCES_C_REMOVE += ../Common/Lzma/Alloc.c \
	../Common/Lzma/Bra.c \
	../Common/Lzma/Bra86.c \
	../Common/Lzma/LzFind.c \
	../Common/Lzma/Lzma2Dec.c \
	../Common/Lzma/Lzma2Enc.c \
	../Common/Lzma/Lzma86Dec.c \
	../Common/Lzma/Lzma86Enc.c \
	../Common/Lzma/LzmaDec.c \
	../Common/Lzma/LzmaEnc.c

PROJECT_SOURCES_CPP_REMOVE += ../Common/3DUtils.cpp \
	../Common/CRT.cpp \
	../Common/CommonRender.cpp \
	../Common/DeferredRenderUtils.cpp \
	../Common/MatrixStack.cpp \
	../Common/PostProcess/PostEffects.cpp \
	../Common/PostProcess/PostProcess.cpp \
	../Common/PostProcess/PostProcessUtils.cpp \
	../Common/RendElements/CREBeam.cpp \
	../Common/RendElements/CREClientPoly.cpp \
	../Common/RendElements/CRECloud.cpp \
	../Common/RendElements/CREDeferredShading.cpp \
	../Common/RendElements/CREDummy.cpp \
	../Common/RendElements/CREFlares.cpp \
	../Common/RendElements/CREFogVolume.cpp \
	../Common/RendElements/CREHDRProcess.cpp \
	../Common/RendElements/CREImposter.cpp \
	../Common/RendElements/CREIrradianceVolume.cpp \
	../Common/RendElements/CREOcLeaf.cpp \
	../Common/RendElements/CREOclusionQuery.cpp \
	../Common/RendElements/CREParticle.cpp \
	../Common/RendElements/CREParticleGPU.cpp \
	../Common/RendElements/CREPostProcess.cpp \
	../Common/RendElements/CREPrismObject.cpp \
	../Common/RendElements/CRESky.cpp \
	../Common/RendElements/CRETempMesh.cpp \
	../Common/RendElements/CRETerrainSector.cpp \
	../Common/RendElements/CREVolumeObject.cpp \
	../Common/RendElements/CREWaterOcean.cpp \
	../Common/RendElements/CREWaterVolume.cpp \
	../Common/RendElements/CREWaterWave.cpp \
	../Common/RendElements/RendElement.cpp \
	../Common/RendElements/CREGameEffect.cpp \
	../Common/RenderAuxGeom.cpp \
	../Common/RenderMesh.cpp \
	../Common/RenderMesh2.cpp \
	../Common/RenderPipeline.cpp \
	../Common/RenderThread.cpp \
	../Common/Renderer.cpp \
	../Common/ResFile.cpp \
	../Common/lzss.cpp \
	../Common/Shaders/Parser.cpp \
	../Common/Shaders/ParserBin.cpp \
	../Common/Shaders/RemoteCompiler.cpp \
	../Common/Shaders/ShaderComponents.cpp \
	../Common/Shaders/ShaderCore.cpp \
	../Common/Shaders/ShaderFXParseBin.cpp \
	../Common/Shaders/ShaderGraph.cpp \
	../Common/Shaders/ShaderParse.cpp \
	../Common/Shaders/ShaderScript.cpp \
	../Common/Shaders/ShaderSerialize.cpp \
	../Common/Shaders/ShaderTemplate.cpp \
	../Common/Shaders/ShaderCache.cpp \
	../Common/ShadowUtils.cpp \
	../Common/Textures/DynTexture.cpp \
	../Common/Textures/Image/CImage.cpp \
	../Common/Textures/Image/CompressedImage.cpp \
	../Common/Textures/Image/DDSImage.cpp \
	../Common/Textures/PowerOf2BlockPacker.cpp \
	../Common/Textures/Texture.cpp \
	../Common/Textures/TextureStreaming.cpp \
	../Common/VideoPlayerInstance.cpp \
	../Common/WaterUtils.cpp \
	../Common/TextMessages.cpp \
	../../CryCommon/EngineSettingsManager.cpp \
	../../CryCommon/ResourceCompilerHelper.cpp \
	D3D10DXBCParser.cpp \
	D3DAmbientOcclusion.cpp \
	D3DColorGradingController.cpp \
	D3DDeferredPasses.cpp \
	D3DDeferredRender.cpp \
	D3DDeferredShading.cpp \
	D3DFXPipeline.cpp \
	D3DFont.cpp \
	D3DHDRRender.cpp \
	D3DHWShader.cpp \
	D3DHWShaderCompiling.cpp \
	D3DIrradianceVolume.cpp \
	D3DLog.cpp \
	D3DOcclQuery.cpp \
	D3DPostProcess.cpp \
	D3DRECloud.cpp \
	D3DREImposter.cpp \
	D3DRendPipeline.cpp \
	D3DRenderAuxGeom.cpp \
	D3DRenderRE.cpp \
	D3DRenderThread.cpp \
	D3DShaders.cpp \
	D3DShadows.cpp \
	D3DSprites.cpp \
	D3DStereo.cpp \
	D3DSystem.cpp \
	D3DTexture.cpp \
	D3DTexturesStreaming.cpp \
	D3DVertBuffer.cpp \
	D3DVideoPlayerInstance.cpp \
	DriverD3D.cpp \
	PostProcessDOF.cpp \
	PostProcessFilters.cpp \
	PostProcessGame.cpp \
	PostProcessGlow.cpp \
	PostProcessMisc.cpp \
	PostProcessMotionBlur.cpp \
	PostProcessRain.cpp \
	PostProcessSunShafts.cpp \
	PostProcessWater.cpp \
	PostProcessHud3D.cpp \
	DeviceManager/DeviceManager.cpp \
	DevBuffer.cpp \
	Profiler/ProfilerSegment.cpp\
	Profiler/PerfCounters.cpp\
	Profiler/GPUProfiler.cpp\
	Profiler/GPUProfilerImpl.cpp\
	Profiler/ValueBar.cpp\
	DXUT/%\
	DXUT11/%\
	Dxut/%\
	Dxps/%\
	DXPS/%

PROJECT_SOURCES_CPP_ADD += XRendererD3D10_main_uber.cpp\
	XRendererD3D10_main2_uber.cpp\
	XRendererD3D10_main3_uber.cpp\
  XRendererD3D10_common_uber.cpp\
	XRendererD3D10_common2_uber.cpp\
	XRendererD3D10_common3_uber.cpp\
  XRendererD3D10_dxps_uber.cpp\
  DXPS/Device/CCryDXPSRenderDevice.cpp
  
PROJECT_SOURCES_C_ADD += XRendererD3D10_Lzma_uber.c

endif


PROJECT_SCAN_CPP := DXPS/CCryDXPSSPU.cpp

# vim:ts=8:sw=8
