// Executable_Xenon.cpp : Defines the entry point for the application.
//

#include "StdAfx.h"
#include <IGameStartup.h>

#define _LAUNCHER
#include <platform_impl.h>

#ifdef _LIB
	// Include common type defines for static linking
	// Manually instantiate templates as needed here.
	#include "Common_TypeInfo.h"
	STRUCT_INFO_T_INSTANTIATE(Vec2_tpl, <float>)
	STRUCT_INFO_T_INSTANTIATE(Vec2_tpl, <int>)
	STRUCT_INFO_T_INSTANTIATE(Vec4_tpl, <short>)
	STRUCT_INFO_T_INSTANTIATE(Vec3_tpl, <int>)
	STRUCT_INFO_T_INSTANTIATE(Ang3_tpl, <float>)
	STRUCT_INFO_T_INSTANTIATE(Quat_tpl, <float>)
	STRUCT_INFO_T_INSTANTIATE(Plane_tpl, <float>)
	STRUCT_INFO_T_INSTANTIATE(Matrix33_tpl, <float>)
	STRUCT_INFO_T_INSTANTIATE(Color_tpl, <float>)
	STRUCT_INFO_T_INSTANTIATE(Color_tpl, <uint8>)
#endif

#if defined(XENON) && defined(_LIB)
	struct SRegFactoryNode* g_pHeadToRegFactories = 0;
#endif

#ifdef XENON_INTRINSICS
  #ifdef _RELEASE
    //const XMVECTOR  g_XMIdentityR0          = {1.0f, 0.0f, 0.0f, 0.0f};
    //const XMVECTOR  g_XMIdentityR1          = {0.0f, 1.0f, 0.0f, 0.0f};
    //const XMVECTOR  g_XMIdentityR2          = {0.0f, 0.0f, 1.0f, 0.0f};
    //const XMVECTOR  g_XMIdentityR3          = {0.0f, 0.0f, 0.0f, 1.0f};
    const XMVECTOR  g_XMOne                 = {1.0f, 1.0f, 1.0f, 1.0f};
    const XMVECTOR  g_XMZero                = {0.0f, 0.0f, 0.0f, 0.0f};
  #endif
#endif

MEMORYSTATUS MemoryStatus;
int GetMemoryStatus()
{
	GlobalMemoryStatus(&MemoryStatus);
	char temp[64];
	sprintf_s(temp,"OS MemUsage: %d MB\n",(MemoryStatus.dwTotalPhys - MemoryStatus.dwAvailPhys)/(1024*1024));
	OutputDebugString(temp);
	return (MemoryStatus.dwTotalPhys - MemoryStatus.dwAvailPhys) >> 20;
}

#ifndef XENON
#	define DLL_INITFUNC_GAME "CreateGameStartup"
#else
#	define DLL_INITFUNC_GAME (LPCSTR)1
#endif
#ifdef _LIB
extern "C" IGameStartup* CreateGameStartup();
#endif

#define ENGINE_CFG_FILE           "d:\\system.cfg"   
#define CONFIG_KEY_FOR_GAMEDLL    "sys_dll_game"
#define DEFAULT_GAMEDLL_FILENAME  "CryGame.dll"

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
class CEngineConfig
{
public:
	string m_gameDLL;

public:
	CEngineConfig()
	{
		m_gameDLL = DEFAULT_GAMEDLL_FILENAME;
	}
	//////////////////////////////////////////////////////////////////////////
	void OnLoadConfigurationEntry( const string &strKey,const string &strValue,const string &strGroup )
	{
		if (strKey.compareNoCase(CONFIG_KEY_FOR_GAMEDLL) == 0)
		{
			m_gameDLL = strValue;
		}
	}
	//////////////////////////////////////////////////////////////////////////
	bool ParseConfig( const char *filename )
	{
		FILE *file = fopen( filename,"rb" );
		if (!file)
			return false;

		int res;
		res = fseek(file,0,SEEK_END);
		assert( res == 0 );
		int nLen = ftell(file);
		res = fseek(file,0,SEEK_SET);
		assert( res == 0 );

		char *sAllText = new char [nLen + 16];

		fread( sAllText,1,nLen,file );

		sAllText[nLen] = '\0';
		sAllText[nLen+1] = '\0';

		string strGroup;			// current group e.g. "[General]"

		char *strLast = sAllText+nLen;
		char *str = sAllText;
		while (str < strLast)
		{
			char *s = str;
			while (str < strLast && *str != '\n' && *str != '\r')
				str++;
			*str = '\0';
			str++;
			while (str < strLast && (*str == '\n' || *str == '\r'))
				str++;


			string strLine = s;

			// detect groups e.g. "[General]"   should set strGroup="General"
			{
				string strTrimmedLine( RemoveWhiteSpaces(strLine) );
				size_t size = strTrimmedLine.size();

				if(size>=3)
					if(strTrimmedLine[0]=='[' && strTrimmedLine[size-1]==']')		// currently no comments are allowed to be behind groups
					{
						strGroup = &strTrimmedLine[1];strGroup.resize(size-2);		// remove [ and ]
						continue;																									// next line
					}
			}

			// skip comments
			if (0<strLine.find( "--" ))
			{
				// extract key
				string::size_type posEq( strLine.find( "=", 0 ) );
				if (string::npos!=posEq)
				{
					string stemp( strLine, 0, posEq );
					string strKey( RemoveWhiteSpaces(stemp) );

					//				if (!strKey.empty())
					{
						// extract value
						string::size_type posValueStart( strLine.find( "\"", posEq + 1 ) + 1 );
						// string::size_type posValueEnd( strLine.find( "\"", posValueStart ) );
						string::size_type posValueEnd( strLine.rfind( '\"' ) );

						string strValue;

						if( string::npos != posValueStart && string::npos != posValueEnd )
							strValue=string( strLine, posValueStart, posValueEnd - posValueStart );
						else
						{
							string strTmp( strLine, posEq + 1, strLine.size()-(posEq + 1) );
							strValue = RemoveWhiteSpaces(strTmp);
						}

						{
							string strTemp;
							strTemp.reserve(strValue.length()+1);
							// replace '\\\\' with '\\' and '\\\"' with '\"'
							for (string::const_iterator iter = strValue.begin(); iter != strValue.end(); ++iter)
							{
								if (*iter == '\\')
								{
									++iter;
									if (iter == strValue.end())
										;
									else if (*iter == '\\')
										strTemp	+= '\\';
									else if (*iter == '\"')
										strTemp += '\"';
								}
								else
									strTemp += *iter;
							}
							strValue.swap( strTemp );

							//						m_pSystem->GetILog()->Log("Setting %s to %s",strKey.c_str(),strValue.c_str());
							OnLoadConfigurationEntry(strKey,strValue,strGroup);
						}
					}					
				}
			} //--
		}
		delete []sAllText;
		fclose(file);

		return true;
	}
	string RemoveWhiteSpaces( string& s )
	{
		s.Trim();
		return s;
	}
};

//////////////////////////////////////////////////////////////////////////
int RunGame(const char *commandLine)
{
	if (strstr(commandLine, "-memReplay"))
	{
#ifndef _LIB
		CryLoadLibrary("CrySystem.dll");
#endif
		CryGetIMemReplay()->ReplayStart();
	}

	CEngineConfig engineCfg;
	engineCfg.ParseConfig( ENGINE_CFG_FILE );

	_fpreset();
	_controlfp( _EM_INEXACT|_EM_INVALID,_MCW_EM ); 


#ifndef _LIB
	// load the game dll
	string sGameDll = string("d:\\") + engineCfg.m_gameDLL;
  HMODULE gameDll = XenonLoadLibrary(sGameDll.c_str());
  if (!gameDll)
  {
    DWORD dwErr = GetLastError();
    return 0;
  }

	// get address of startup function
	IGameStartup::TEntryFunction CreateGameStartup = (IGameStartup::TEntryFunction)GetProcAddress(gameDll,DLL_INITFUNC_GAME );
	if (!CreateGameStartup)
	{
		// dll is not a compatible game dll
		FreeLibrary(gameDll);
		return 0;
	}
#endif

	SSystemInitParams startupParams;

	startupParams.hInstance = 0;
	startupParams.sLogFileName = "Game.log";
	strcpy_s(startupParams.szSystemCmdLine, commandLine);

	// create the startup interface
	IGameStartup* pGameStartup = CreateGameStartup();

	if (!pGameStartup)
	{
		//MessageBox(0, "Failed to create the GameStartup Interface!", "Error", MB_OK | MB_DEFAULT_DESKTOP_ONLY);

		return 0;
	}

	// run the game
	if (pGameStartup->Init(startupParams))
	{
		int exitCode = pGameStartup->Run(NULL);
		DmReboot(DMBOOT_TITLE);
		pGameStartup->Shutdown();
		pGameStartup = 0;
#ifndef _LIB
    FreeLibrary(gameDll);
#endif
		return exitCode;
	}

	// if initialization failed, we still need to call shutdown
	pGameStartup->Shutdown();
	pGameStartup = 0;

	//MessageBox(0, "Failed to initialize the GameStartup Interface!", "Error", MB_OK | MB_DEFAULT_DESKTOP_ONLY);

	return 0;
}

//-------------------------------------------------------------------------------------
// Name: main()
// Desc: The application's entry point
//-------------------------------------------------------------------------------------

void __cdecl main()
{
	GetMemoryStatus();

#if CRY_XENON_CRASH_HANDLING
	SetUnhandledExceptionFilter( handleException );
#endif
	GetMemoryStatus();
	RunGame(GetCommandLine());

  //XLaunchNewImage("", 0); // Reboot the dev kit
}
