/*************************************************************************
	Crytek Source File.
	Copyright (C), Crytek Studios, 2001-2004.
	-------------------------------------------------------------------------
	$Id$
	$DateTime$
	Description: AmmoPickup Implementation

	-------------------------------------------------------------------------
	History:
	- 9:2:2006   17:09 : Created by Mrcio Martins

*************************************************************************/
#ifndef __AMMOPICKUP_H__
#define __AMMOPICKUP_H__

#if _MSC_VER > 1000
# pragma once
#endif


#include <IItemSystem.h>
#include "Weapon.h"


class CAmmoPickup :
	public CWeapon
{
public:
	virtual void PostInit( IGameObject * pGameObject );
	virtual bool CanUse(EntityId userId) const;
	virtual bool CanPickUp(EntityId pickerId) const;

	virtual void SerializeSpawnInfo( TSerialize ser );
	virtual ISerializableInfoPtr GetSpawnInfo();

	virtual void PickUp(EntityId pickerId, bool sound, bool select, bool keepHistory, const char *setup = NULL);
	virtual bool CheckAmmoRestrictions(EntityId pickerId);
	virtual void GetMemoryUsage(ICrySizer * s) const
	{
		s->AddObject(this, sizeof(*this));
		s->AddObject(m_modelName);
		CWeapon::GetInternalMemoryUsage(s); // collect memory of parent class
	}

	const char* GetAmmoName() const {return m_ammoName.c_str();}

private:
	
	//Special case for grenades (might need to switch firemode)
	void    ShouldSwitchGrenade(IEntityClass* pClass);
	void    OnIncendiaryAmmoPickedUp(IEntityClass *pClass, int count);

	ItemString	m_modelName;
	ItemString	m_ammoName;
	int					m_ammoCount;
};


#endif // __AMMOPICKUP_H__
