/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Single-shot Fire Mode Implementation

-------------------------------------------------------------------------
History:
- 11:9:2004   15:00 : Created by Mrcio Martins

*************************************************************************/
#ifndef __CHARGE_H__
#define __CHARGE_H__

#if _MSC_VER > 1000
# pragma once
#endif


#include "Automatic.h"

class CCharge :
	public CAutomatic
{
public:
	CCharge();
	virtual ~CCharge();

	virtual void Update(float frameTime, uint32 frameId);
	virtual void GetMemoryUsage(ICrySizer * s) const;

	virtual void Activate(bool activate);

	virtual void StopFire();

	virtual bool Shoot(bool resetAnimation, bool autoreload, bool isRemote=false);

	virtual void ChargeEffect(bool attach);
	virtual void ChargedShoot();

protected:

	int							m_charged;
	bool						m_charging;
	float						m_chargeTimer;
	bool						m_autoreload;

	uint32					m_chargeEffectId;
	float						m_chargedEffectTimer;
};

#endif //__CHARGE_H__
