/*************************************************************************
	Crytek Source File.
	Copyright (C), Crytek Studios, 2009.
	-------------------------------------------------------------------------
	$Id$
	$DateTime$
	Description: 

	-------------------------------------------------------------------------
	History:
	- 03:09:2009  : Created by Colin Gulliver

*************************************************************************/

#ifndef _GameRulesStandardSetup_h_
#define _GameRulesStandardSetup_h_

#if _MSC_VER > 1000
# pragma once
#endif

#include "GameRulesModules/IGameRulesPlayerSetupModule.h"
#include "GameRulesModules/IGameRulesPickupListener.h"
#include "GameRulesModules/IGameRulesRoundsListener.h"
#include "GameRulesModules/IGameRulesTeamChangedListener.h"
#include "GameRulesModules/IGameRulesRevivedListener.h"
#include "GameRulesModules/IGameRulesClientConnectionListener.h"
#include "GameRulesTypes.h"

struct IInventory;

class CGameRulesStandardSetup : public IGameRulesPlayerSetupModule,
								public IGameRulesPickupListener,
								public IGameRulesRoundsListener,
								public IGameRulesTeamChangedListener,
								public IGameRulesRevivedListener,
								public IGameRulesClientConnectionListener
{
protected:
	typedef CryFixedStringT<32> TFixedString;

public:
	CGameRulesStandardSetup();
	virtual ~CGameRulesStandardSetup();

	// IGameRulesPlayerSetupModule
	virtual void Init(XmlNodeRef xml);
	virtual void PostInit();

	virtual void OnClientConnect(int channelId, bool isReset, const char* playerName);
	virtual void OnPlayerRevived(EntityId playerId);
	virtual void SetupPlayer(EntityId playerId);

	virtual void SvOnStartNewRound(bool isReset);
	// ~IGameRulesPlayerSetupModule

	// IGameRulesPickupListener
	virtual void OnItemPickedUp(EntityId itemId, EntityId actorId);
	virtual void OnItemDropped(EntityId itemId, EntityId actorId);
	virtual void OnPickupEntityAttached(EntityId entityId, EntityId actorId) {};
	virtual void OnPickupEntityDetached(EntityId entityId, EntityId actorId, bool isOnRemove) {};
	// ~IGameRulesPickupListener

	// IGameRulesRoundsListener
	virtual void OnRoundStart() {}
	virtual void ClRoundsNetSerializeReadState(int newState, int curState);
	// ~IGameRulesRoundsListener

	// IGameRulesTeamChangedListener
	virtual void OnChangedTeam(EntityId entityId, int oldTeamId, int newTeamId);
	// ~IGameRulesTeamChangedListener

	// IGameRulesRevivedListener
	virtual void EntityRevived(EntityId entityId);
	// ~IGameRulesRevivedListener

	// IGameRulesClientConnectionListener
	virtual void OnClientConnect(int channelId, bool isReset, EntityId playerId) {};
	virtual void OnClientDisconnect(int channelId, EntityId playerId) {};
	virtual void OnClientEnteredGame(int channelId, bool isReset, EntityId playerId) {};
	virtual void OnOwnClientEnteredGame();
	// ~IGameRulesClientConnectionListener

protected:
	void SetAmmoCapacity(IInventory *pInventory, const char *pAmmoClass, int amount);
	bool IsInIgnoreItemTypeList(EntityId itemId);
	void CallLuaFunc(TFixedString* funcName);
	void CallLuaFunc1e(TFixedString* funcName, EntityId e);

	static const int MAX_IGNORE_REMOVE_ITEM_CLASSES = 5;
	const IEntityClass *m_itemRemoveIgnoreClasses[MAX_IGNORE_REMOVE_ITEM_CLASSES];

	TFixedString  m_luaSetupPlayerTeamSpecificsFunc;
	TFixedString  m_luaResetPlayerTeamSpecificsFunc;
	TFixedString  m_luaEquipTeamSpecificsFunc;

	CGameRules*  m_pGameRules;

	int m_numIgnoreItems;

	float m_itemAbandonedTimerLength;

	bool m_usesTeamSpecifics;
};

#endif // _GameRulesStandardSetup_h_