/*************************************************************************
	Crytek Source File.
	Copyright (C), Crytek Studios, 2009.
	-------------------------------------------------------------------------
	$Id$
	$DateTime$
	Description: 
		Standard game rules module to handle victory conditions for all vs 
		all games
	-------------------------------------------------------------------------
	History:
	- 19:10:2009  : Created by Colin Gulliver

*************************************************************************/

#ifndef _GAME_RULES_STANDARD_VICTORY_CONDITIONS_PLAYER_H_
#define _GAME_RULES_STANDARD_VICTORY_CONDITIONS_PLAYER_H_

#if _MSC_VER > 1000
# pragma once
#endif

#include "GameRulesStandardVictoryConditionsTeam.h"

class CGameRules;

class CGameRulesStandardVictoryConditionsPlayer : public CGameRulesStandardVictoryConditionsTeam
{
public:
	typedef CGameRulesStandardVictoryConditionsTeam  inherited;

public:
	CGameRulesStandardVictoryConditionsPlayer();
	~CGameRulesStandardVictoryConditionsPlayer();

	virtual void  Init(XmlNodeRef xml);
	virtual void	Update(float frameTime);

	// IGameRulesVictoryConditionsModule
	virtual void	ClVictoryTeam(int teamId, EGameOverReason reason) {};
	virtual void	ClVictoryPlayer(int playerId, EGameOverReason reason);
	// ~IGameRulesVictoryConditionsModule

protected:
	struct SPlayerScoreResult
	{
		SPlayerScoreResult() : m_maxScore(0), m_maxScorePlayerId(0) { };

		int m_maxScore;
		EntityId m_maxScorePlayerId;
	};

	typedef CryFixedStringT<32> TFixedString;

	TFixedString  m_luaFuncStartSuddenDeathSv;
	TFixedString  m_luaFuncEndSuddenDeathSv;

	TFixedString  m_tmpSuddenDeathMsg;

	void	GetMaxPlayerScore(SPlayerScoreResult &result);

	// CGameRulesStandardVictoryConditionsTeam
	virtual void CheckScoreLimit();
	virtual void CheckTimeLimit();
	virtual void TimeLimitExpired();
	// ~CGameRulesStandardVictoryConditionsTeam

	void	OnEndGamePlayer(EntityId playerId, EGameOverReason reason);

	void	CallLuaFunc(TFixedString* funcName);
};

#endif // _GAME_RULES_STANDARD_VICTORY_CONDITIONS_PLAYER_H_