#include "StdAfx.h"

#include "HUD_DogTagCollectedPopup.h"

#include "Game.h"
#include "GameRules.h"
#include "GameRulesModules/IGameRulesStateModule.h"
#include "GameRulesModules/IGameRulesPlayerStatsModule.h"
#include "Utility/CryWatch.h"

CHUD_DogTagCollectedPopup::CHUD_DogTagCollectedPopup()
{
	m_tagInfo.Clear();

	m_pAsset = NULL;
	m_vo = NULL;
	m_vo_PlayerName_Text = NULL;
	m_vo_ClanTag_Text = NULL;
	m_vo_Rank_Text_Text = NULL;
	m_vo_SuitModes_Suit_Armour_Text = NULL;
	m_vo_SuitModes_Suit_Power_Text = NULL;
	m_vo_SuitModes_Suit_Stealth_Text = NULL;
	m_vo_SuitModes_Suit_Tactical_Text = NULL;

	SetState(eState_Hidden);
}

void CHUD_DogTagCollectedPopup::Init( void )
{
	m_pAsset = GetAsset("DogTagCollectedPopup");
	CRY_ASSERT_MESSAGE(m_pAsset!=CHUD::s_pHUDAssetNULL, "'Dog Tag Collected Popup' flash asset not loaded, but trying to init!");

	HUD_FLASVAROBJ_REG(m_pAsset, "dog_tags", m_vo);
	HUD_FLASVAROBJ_REG(m_pAsset, "dog_tags.PlayerName.Text", m_vo_PlayerName_Text);
	HUD_FLASVAROBJ_REG(m_pAsset, "dog_tags.ClanTag.Text", m_vo_ClanTag_Text);
	HUD_FLASVAROBJ_REG(m_pAsset, "dog_tags.Rank_Text.Text", m_vo_Rank_Text_Text);
	HUD_FLASVAROBJ_REG(m_pAsset, "dog_tags.SuitModes.Suit_Armour.Text", m_vo_SuitModes_Suit_Armour_Text);
	HUD_FLASVAROBJ_REG(m_pAsset, "dog_tags.SuitModes.Suit_Power.Text", m_vo_SuitModes_Suit_Power_Text);
	HUD_FLASVAROBJ_REG(m_pAsset, "dog_tags.SuitModes.Suit_Stealth.Text", m_vo_SuitModes_Suit_Stealth_Text);
	HUD_FLASVAROBJ_REG(m_pAsset, "dog_tags.SuitModes.Suit_Tactical.Text", m_vo_SuitModes_Suit_Tactical_Text);

	m_vo->SetVisible(false);
}

void CHUD_DogTagCollectedPopup::PreDelete( void )
{
	HUD_FLASHOBJ_SAFERELEASE(m_vo);
	HUD_FLASHOBJ_SAFERELEASE(m_vo_PlayerName_Text);
	HUD_FLASHOBJ_SAFERELEASE(m_vo_ClanTag_Text);
	HUD_FLASHOBJ_SAFERELEASE(m_vo_Rank_Text_Text);
	HUD_FLASHOBJ_SAFERELEASE(m_vo_SuitModes_Suit_Armour_Text);
	HUD_FLASHOBJ_SAFERELEASE(m_vo_SuitModes_Suit_Power_Text);
	HUD_FLASHOBJ_SAFERELEASE(m_vo_SuitModes_Suit_Stealth_Text);
	HUD_FLASHOBJ_SAFERELEASE(m_vo_SuitModes_Suit_Tactical_Text);
}

void CHUD_DogTagCollectedPopup::Update( float frameTime )
{
	if (m_state == eState_Hidden)
	{
		// hidden state doesn't do anything, not even update state timer
		return;
	}

	const float  stateTimer = (m_stateTimer + frameTime);
	m_stateTimer = stateTimer;
	
	switch (m_state)
	{
	case eState_Show:
		{
			m_vo->SetVisible(true);

			char  tmpstr[3];

			m_vo_PlayerName_Text->SetText(m_tagInfo.m_ownerName);
			m_vo_ClanTag_Text->SetText(m_tagInfo.m_clanName);

			_snprintf(tmpstr, sizeof(tmpstr), "%d", m_tagInfo.m_rank);
			m_vo_Rank_Text_Text->SetText(tmpstr);

			_snprintf(tmpstr, sizeof(tmpstr), "%d", m_tagInfo.m_progressArmour);
			m_vo_SuitModes_Suit_Armour_Text->SetText(tmpstr);

			_snprintf(tmpstr, sizeof(tmpstr), "%d", m_tagInfo.m_progressPower);
			m_vo_SuitModes_Suit_Power_Text->SetText(tmpstr);

			_snprintf(tmpstr, sizeof(tmpstr), "%d", m_tagInfo.m_progressStealth);
			m_vo_SuitModes_Suit_Stealth_Text->SetText(tmpstr);

			_snprintf(tmpstr, sizeof(tmpstr), "%d", m_tagInfo.m_progressTactical);
			m_vo_SuitModes_Suit_Tactical_Text->SetText(tmpstr);

			// [tlh] TODO trigger animation or fade-in or whatever
			SetState(eState_Show_1);
			break;
		}
	case eState_Show_1:
		{
			// [tlh] TODO wait or time animation or fade-in or whatever to finish
			SetState(eState_Showing);
			break;
		}
	case eState_Showing:
		{
			if (stateTimer > g_pGameCVars->g_dogtagsHUDPopupDuration)
			{
				SetState(eState_Hide);
			}
			break;
		}
	case eState_Hide:
		{
			// [tlh] TODO trigger animation or fade-out or whatever
			SetState(eState_Hide_1);
			break;
		}
	case eState_Hide_1:
		{
			// [tlh] TODO wait or time animation or fade-out or whatever to finish
			m_vo->SetVisible(false);
			SetState(eState_ProcessQueue);
			break;
		}
	case eState_ProcessQueue:
		{
			// [tlh] TODO!! (if design want it...)
			SetState(eState_Hidden);
			break;
		}
	default:
		{
			CRY_ASSERT_MESSAGE(0, string().Format("Unexpected state value %d", m_state));
			break;
		}
	}

	m_pAsset->Update( frameTime );
}

void CHUD_DogTagCollectedPopup::Draw( void )
{
	m_pAsset->Draw();
}

void CHUD_DogTagCollectedPopup::OnHUDEvent( const SHUDEvent& event )
{
	switch (event.eventType)
	{
	case eHUDEvent_OnDogTagCollected:
		{
			if (!g_pGameCVars->g_dogtagsHUDPopupEnable)
			{
				CryLog("[tlh] CHUD_DogTagCollectedPopup::OnHUDEvent: eHUDEvent_OnDogTagCollected: ignoring event because g_dogtagsHUDPopupEnable cvar is not set");
				break;
			}

			if (m_state == eState_Hidden)
			{
				const CDogtag::STagInfo*  eventTagInfo = (CDogtag::STagInfo*) event.GetData(0).GetPtr();
				CRY_ASSERT(eventTagInfo);
				memcpy(&m_tagInfo, eventTagInfo, sizeof(m_tagInfo));

				CryLog("CHUD_DogTagCollectedPopup::OnHUDEvent: eHUDEvent_OnDogTagCollected: collected tag, owner '%s'", m_tagInfo.m_ownerName);

				SetState(eState_Show);
			}
			else
			{
				CRY_ASSERT_MESSAGE(0, "[tlh] TODO trying to display a dog tag when there's one already displaying, maybe queue additional tags if that's what design want?");
			}

			break;
		}
	}
}
