#ifndef ___CHUD_DOGTAGCOLLECTED__
#define ___CHUD_DOGTAGCOLLECTED__

#include "HUD/HUDObject.h"
#include "Dogtag.h"

class CHUD_DogTagCollectedPopup : public CHUDObject
{
private:
	enum EState
	{
		eState_Hidden = 0,
		eState_Show,
		eState_Show_1,
		eState_Showing,
		eState_Hide,
		eState_Hide_1,
		eState_ProcessQueue,
	};
	typedef uint8  TState;

public:
	CHUD_DogTagCollectedPopup();

	//CHUDObject
	virtual void Init( void );
	virtual void Draw( void );
	virtual void Update( float frameTime );
	virtual void OnHUDEvent(const SHUDEvent& event);
	virtual void PreDelete( void );
	//~CHUDObject
	
private:
	ILINE void SetState(TState s) { m_state = s; m_stateTimer = 0.f; }

	CDogtag::STagInfo  m_tagInfo;

	IHUDAsset*  m_pAsset;
	IFlashVariableObject*  m_vo;
	IFlashVariableObject*  m_vo_PlayerName_Text;
	IFlashVariableObject*  m_vo_ClanTag_Text;
	IFlashVariableObject*  m_vo_Rank_Text_Text;
	IFlashVariableObject*  m_vo_SuitModes_Suit_Armour_Text;
	IFlashVariableObject*  m_vo_SuitModes_Suit_Power_Text;
	IFlashVariableObject*  m_vo_SuitModes_Suit_Stealth_Text;
	IFlashVariableObject*  m_vo_SuitModes_Suit_Tactical_Text;

	float  m_stateTimer;
	TState  m_state;
};


#endif //___CHUD_DOGTAGCOLLECTED__
