#include "StdAfx.h"

#include "HUD_LeavingBattle.h"


CHUD_LeavingBattleNotification::CHUD_LeavingBattleNotification()
: m_visible(false)
{
	//...
}

CHUD_LeavingBattleNotification::~CHUD_LeavingBattleNotification()
{
	//...
}

void CHUD_LeavingBattleNotification::Update(float frameTime)
{
	if( m_visible)
		m_pPlayer->Update(frameTime);
}

void CHUD_LeavingBattleNotification::Draw()
{
	if( m_visible)
		m_pPlayer->Draw();
}

void CHUD_LeavingBattleNotification::Init()
{
	m_pPlayer = GetFirstAsset();
}

void CHUD_LeavingBattleNotification::OnHUDEvent(const SHUDEvent& hudEvent)
{
	//...
	if( hudEvent.eventType == eHUDEvent_LeavingBattleArea )
	{
		m_visible = true;
	}
	else // if( hudEvent.eventType == eHUDEvent_ReturningToBattleArea )
	{
		m_visible = false;
	}
}