#include "StdAfx.h"
#include "HUD_ProgressNotify.h"

CHUD_ProgressNotify::CHUD_ProgressNotify() 
: m_voXPNotify(NULL)
, m_voXPNotify_Text(NULL)
, m_voScoreNotify(NULL)
, m_voMajorEvents(NULL)
, m_voMinorNotify(NULL)
, m_pAsset(NULL)
, m_activeQueueMessageIdx(-1)
, m_queueFirstFreeIdx(0)
, m_frameIncrement(0.0f)
, m_messagesInQueue(0)
, m_curFrame(1)
{
	for( int i=0; i<HUD_MAX_XP_QUEUE_SIZE; ++i )
	{
		m_messageQueue.push_back(new SXPMessage());
	}
}

CHUD_ProgressNotify::~CHUD_ProgressNotify()
{
	for( int i=0; i<HUD_MAX_XP_QUEUE_SIZE; ++i )
	{
		SAFE_DELETE( m_messageQueue[i] );
	}
}

void CHUD_ProgressNotify::Init( void )
{
	m_pAsset = GetAsset("XPNotify");

	HUD_FLASVAROBJ_REG( m_pAsset, "HUD_ScoreNotify", m_voScoreNotify );
	HUD_FLASVAROBJ_REG( m_pAsset, "HUD_MajorNotify", m_voMajorEvents );
	HUD_FLASVAROBJ_REG( m_pAsset, "HUD_MinorNotify", m_voMinorNotify );

	HUD_FLASVAROBJ_REG( m_pAsset, "HUD_XPNotify", m_voXPNotify ); // Main animation time line.
	HUD_FLASVAROBJ_REG( m_pAsset, "HUD_XPNotify.Text_Container.HUD_XP_Notify_Text.Text", m_voXPNotify_Text); // Not sure why SetText on this object works, it's a MC containing text.

	m_voXPNotify->SetVisible(false);

	m_voScoreNotify->SetVisible(false);
	m_voMajorEvents->SetVisible(false);
	m_voMinorNotify->SetVisible(false);
}

void CHUD_ProgressNotify::PreDelete( void )
{
	HUD_FLASHOBJ_SAFERELEASE( m_voXPNotify );
	HUD_FLASHOBJ_SAFERELEASE( m_voXPNotify_Text );

	HUD_FLASHOBJ_SAFERELEASE( m_voScoreNotify );
	HUD_FLASHOBJ_SAFERELEASE( m_voMajorEvents );
	HUD_FLASHOBJ_SAFERELEASE( m_voMinorNotify );
}

void CHUD_ProgressNotify::Update( float frameTime )
{
	if( m_activeQueueMessageIdx == -1 )
	{
		m_frameIncrement = 0.0f;
		return;
	}

	// do animation stuff
	const int messagesInQueue = m_messagesInQueue;
	float animFrameIncrement = 1.0f/frameTime;
	if( messagesInQueue < HUD_XP_QUEUE_SIZE_BEFORE_FAST_SCROLL )
	{
		animFrameIncrement *= HUD_XP_SINGLE_TIME_MULTIPLIER;
	}
	else
	{
		animFrameIncrement *= HUD_XP_MULTIPLE_TIME_MULTIPLIER;
	}

	float frameIncrement = m_frameIncrement;
	frameIncrement += animFrameIncrement;
	if( frameIncrement>1.0f )
	{
		frameIncrement -= 1.0f; // at 30fps this should 'catch up'
		const int curFrame = m_curFrame + 1;
		m_voXPNotify->GotoAndStop(curFrame);
		m_curFrame = curFrame;
		UpdateQueue( );
	}
	m_frameIncrement = frameIncrement;

	m_pAsset->Update( frameTime );
}

void CHUD_ProgressNotify::Draw( void )
{
	m_pAsset->Draw();
}

void CHUD_ProgressNotify::OnHUDEvent(const SHUDEvent& event)
{
	CRY_ASSERT( event.eventType == eHUDEvent_OnNewXP );

	const EPPType type = static_cast<EPPType>(event.GetData(0).GetInt());
	const int xp = event.GetData(1).GetInt();

	NewXPElement(type, xp);
}

void CHUD_ProgressNotify::NewXPElement(const EPPType type, const int xp)
{
	int messagesInQueue = m_messagesInQueue;

	CRY_ASSERT_MESSAGE( (/*free*/messagesInQueue < HUD_MAX_XP_QUEUE_SIZE && m_queueFirstFreeIdx != -1) || (/*full*/messagesInQueue >= HUD_MAX_XP_QUEUE_SIZE && m_queueFirstFreeIdx == -1), "HUD: should never happen!" );
	if( messagesInQueue >= HUD_MAX_XP_QUEUE_SIZE || m_queueFirstFreeIdx == -1 )
	{
		CryHUDWarning(VALIDATOR_MODULE_GAME, VALIDATOR_WARNING, "HUD: XP message queue full!" );
		return;
	}
	
	CryLogAlways ("CHUD_ProgressNotify::NewXPElement rewarding %d xp to local player", xp);

	SXPMessage* newMessage = m_messageQueue[m_queueFirstFreeIdx];
	TXPStringType& message = newMessage->message;

	char number[8];
	sprintf (number,"%d", xp);

	switch( type )
	{
	case EPP_TeamRadar: message.Format("@ui_xppoints_teamradar");											break;
	case EPP_EMPStrike: message.Format("@ui_xppoints_empstrike");											break;
	case EPP_SatStrike: message.Format("@ui_xppoints_satstrike");											break;
	case EPP_SuitBoost: message.Format("@ui_xppoints_suitboost");											break;
	case EPP_DogtagCollection: message.Format("@ui_xppoints_dogtags");								break;
	case EPP_Headshot: message.Format("@ui_xppoints_headshot");												break;
	case EPP_AirDeath: message.Format("@ui_xppoints_airdeath");												break;
	case EPP_MeleeTakedown: message.Format("@ui_xppoints_meleetakedown");							break;
	case EPP_PistolKill: message.Format("@ui_xppoints_pistolkill");										break;
	case EPP_BlindKill: message.Format("@ui_xppoints_blindkill");											break;
	case EPP_Impale: message.Format("@ui_xppoints_impale");														break;
	case EPP_FirstBlood: message.Format("@ui_xppoints_firstblood");										break;
	case EPP_Rumbled: message.Format("@ui_xppoints_rumbled");													break;
	case EPP_UnderwaterKill: message.Format("@ui_xppoints_underwaterkill");						break;
	case EPP_RoadKill: message.Format("@ui_xppoints_roadkill");												break;
	case EPP_NearDeathExperience: message.Format("@ui_xppoints_neardeathexperience");	break;
	case EPP_KillJoy:	message.Format("@ui_xppoints_killjoy");													break;
	}

	CRY_ASSERT(message.empty() == false);

	const char * localised = (message.size() && message.c_str()[0] == '@') ? g_pGame->GetHUD()->LocalizeString(message.c_str()) : message.c_str();
	message.Format( "%s %s%sXP", localised, (xp==0 ? "" : (xp < 0 ? "-" : "+") ), number);

	messagesInQueue += 1;
	m_messagesInQueue = messagesInQueue;
	if( messagesInQueue < HUD_MAX_XP_QUEUE_SIZE )
	{
		const unsigned int curIdx = m_queueFirstFreeIdx;
		unsigned int nextIdx = 0;
		if( curIdx+1 < HUD_MAX_XP_QUEUE_SIZE )
		{
			nextIdx = curIdx+1;
		}

		m_queueFirstFreeIdx = nextIdx; // nextIdx should always be free.

		if( messagesInQueue == 1 ) // 1st new one in queue
		{
			m_activeQueueMessageIdx = curIdx;
			SetData( );
		}
	}
	else // messagesInQueue > HUD_MAX_XP_QUEUE_SIZE
	{
		m_queueFirstFreeIdx = -1;
	}
}

void CHUD_ProgressNotify::UpdateQueue( void )
{
	if( m_curFrame > HUD_XP_NUMBER_OF_ANIM_FRAMES )
	{
		unsigned int messagesInQueue = m_messagesInQueue-1;

		if( m_queueFirstFreeIdx==-1 )
		{
			m_queueFirstFreeIdx = m_activeQueueMessageIdx;
		}

		if( messagesInQueue <= 0 )
		{ // no messages
			m_activeQueueMessageIdx = -1;
		}
		else
		{ // messages in queue to display
			// Get next idx
			const unsigned int curIdx = m_activeQueueMessageIdx;	
			unsigned int nextIdx = 0;
			if( curIdx+1 < HUD_MAX_XP_QUEUE_SIZE )
			{
				nextIdx = curIdx+1;
			}
			m_activeQueueMessageIdx = nextIdx;


			// Todo update next in chain.
		}

		m_messagesInQueue = messagesInQueue;

		SetData();
	}
}

void CHUD_ProgressNotify::SetData( void )
{
	m_curFrame = 1;
	m_voXPNotify->GotoAndStop(1);
	CRY_ASSERT( ((m_messagesInQueue==0) && (m_activeQueueMessageIdx<0)) || ((m_messagesInQueue>0) && (m_activeQueueMessageIdx>=0)) );
	if( m_activeQueueMessageIdx < 0  )
	{
		m_voXPNotify->SetVisible(false);
		m_voXPNotify_Text->SetVisible(false);
		m_voXPNotify_Text->SetText( "" );
	}
	else
	{
		m_voXPNotify->SetVisible(true);
		m_voXPNotify_Text->SetVisible(true);
		SXPMessage* activeMessageData = m_messageQueue[m_activeQueueMessageIdx];
		m_voXPNotify_Text->SetText( activeMessageData->message.c_str() );
	}
}

#if ENABLE_HUD_EXTRA_DEBUG
void CHUD_ProgressNotify::CMDTriggerXP( IConsoleCmdArgs *pArgs )
{
	int newScore = 10;
	SHUDEvent xpHudEvent(eHUDEvent_OnNewXP);

	xpHudEvent.m_data.clear();
	xpHudEvent.AddData(EPP_TeamRadar);
	xpHudEvent.AddData(newScore+=10);
	CHUD::CallEvent(xpHudEvent);

	xpHudEvent.m_data.clear();
	xpHudEvent.AddData(EPP_EMPStrike);
	xpHudEvent.AddData(newScore+=10);
	CHUD::CallEvent(xpHudEvent);

	xpHudEvent.m_data.clear();
	xpHudEvent.AddData(EPP_SatStrike);
	xpHudEvent.AddData(newScore+=10);
	CHUD::CallEvent(xpHudEvent);

	xpHudEvent.m_data.clear();
	xpHudEvent.AddData(EPP_SuitBoost);
	xpHudEvent.AddData(newScore+=10);
	CHUD::CallEvent(xpHudEvent);

	xpHudEvent.m_data.clear();
	xpHudEvent.AddData(EPP_DogtagCollection);
	xpHudEvent.AddData(newScore+=10);
	CHUD::CallEvent(xpHudEvent);

	xpHudEvent.m_data.clear();
	xpHudEvent.AddData(EPP_Headshot);
	xpHudEvent.AddData(newScore+=10);
	CHUD::CallEvent(xpHudEvent);

	xpHudEvent.m_data.clear();
	xpHudEvent.AddData(EPP_AirDeath);
	xpHudEvent.AddData(newScore+=10);
	CHUD::CallEvent(xpHudEvent);

	xpHudEvent.m_data.clear();
	xpHudEvent.AddData(EPP_MeleeTakedown);
	xpHudEvent.AddData(newScore+=10);
	CHUD::CallEvent(xpHudEvent);

	xpHudEvent.m_data.clear();
	xpHudEvent.AddData(EPP_PistolKill);
	xpHudEvent.AddData(newScore+=10);
	CHUD::CallEvent(xpHudEvent);

	xpHudEvent.m_data.clear();
	xpHudEvent.AddData(EPP_BlindKill);
	xpHudEvent.AddData(newScore+=10);
	CHUD::CallEvent(xpHudEvent);

	xpHudEvent.m_data.clear();
	xpHudEvent.AddData(EPP_Impale);
	xpHudEvent.AddData(newScore+=10);
	CHUD::CallEvent(xpHudEvent);

	xpHudEvent.m_data.clear();
	xpHudEvent.AddData(EPP_FirstBlood);
	xpHudEvent.AddData(newScore+=10);
	CHUD::CallEvent(xpHudEvent);

	xpHudEvent.m_data.clear();
	xpHudEvent.AddData(EPP_Rumbled);
	xpHudEvent.AddData(newScore+=10);
	CHUD::CallEvent(xpHudEvent);

	xpHudEvent.m_data.clear();
	xpHudEvent.AddData(EPP_UnderwaterKill);
	xpHudEvent.AddData(newScore+=10);
	CHUD::CallEvent(xpHudEvent);

	xpHudEvent.m_data.clear();
	xpHudEvent.AddData(EPP_RoadKill);
	xpHudEvent.AddData(newScore+=10);
	CHUD::CallEvent(xpHudEvent);

	xpHudEvent.m_data.clear();
	xpHudEvent.AddData(EPP_NearDeathExperience);
	xpHudEvent.AddData(newScore+=10);
	CHUD::CallEvent(xpHudEvent);

	xpHudEvent.m_data.clear();
	xpHudEvent.AddData(EPP_KillJoy);
	xpHudEvent.AddData(newScore+=10);
	CHUD::CallEvent(xpHudEvent);
}
#endif // ENABLE_HUD_EXTRA_DEBUG
