#ifndef ___HUD_PROGRESSNOTIFY___
#define ___HUD_PROGRESSNOTIFY___

#include "HUD/HUDObject.h"

#include "Utility/CryFixedArray.h"
#include "PlayerProgression.h"

#define HUD_MAX_XP_QUEUE_SIZE 16

#define HUD_XP_QUEUE_SIZE_BEFORE_FAST_SCROLL (int)3
#define HUD_XP_SINGLE_TIME_MULTIPLIER (float)0.5f
#define HUD_XP_MULTIPLE_TIME_MULTIPLIER (float)2.0f

#define HUD_XP_NUMBER_OF_ANIM_FRAMES (int)100

class CHUD_ProgressNotify : public CHUDObject
{
private : // types

	typedef CryFixedStringT<64> TXPStringType;

	struct SXPMessage{
		TXPStringType message;
		int score;
	};
	typedef CryFixedArray<SXPMessage*, HUD_MAX_XP_QUEUE_SIZE> TXPMessageBuffer;

public : // public interface

	 CHUD_ProgressNotify();
	~CHUD_ProgressNotify();

	//CHUDObject
	virtual void Init( void );
	virtual void Draw( void );
	virtual void Update( float frameTime );
	virtual void OnHUDEvent(const SHUDEvent& event);
	virtual void PreDelete( void );
	//~CHUDObject

#if ENABLE_HUD_EXTRA_DEBUG
	// Console cmds
	static void CMDTriggerXP( IConsoleCmdArgs *pArgs );
#endif // ENABLE_HUD_EXTRA_DEBUG

protected : // private funcs

	void NewXPElement(const EPPType type, const int xp);
	void UpdateQueue( void );
	void SetData( void );
protected : // member vars

	TXPMessageBuffer      m_messageQueue;

	IFlashVariableObject* m_voScoreNotify;
	IFlashVariableObject* m_voMajorEvents;
	IFlashVariableObject* m_voMinorNotify;

	IFlashVariableObject* m_voXPNotify;
	IFlashVariableObject* m_voXPNotify_Text;

	IHUDAsset*            m_pAsset;
	int                   m_activeQueueMessageIdx;
	int                   m_queueFirstFreeIdx;
	float                 m_frameIncrement;
	unsigned int          m_messagesInQueue;
	unsigned int          m_curFrame;

};

#endif // ___HUD_PROGRESSNOTIFY___
