#include "StdAfx.h"
#include "HUD_ScoreNotify.h"

#include "GameRules.h"
#include "GameRulesModules/IGameRulesPlayerStatsModule.h"
#include "GameCodeCoverage/GameCodeCoverageTracker.h"

#include "Actor.h"

CHUD_ScoreNotify::CHUD_ScoreNotify() 
: m_voXPNotify(NULL)
, m_voMajorEvents(NULL)
, m_voMinorNotify(NULL)
, m_voScoresRoot(NULL)
, m_voScoreNotify_OtherPlayer(NULL)
, m_voScoreNotify_OtherPlayer_MainMessage_Enemy(NULL)
, m_voScoreNotify_OtherPlayer_MainMessage_Team(NULL)
, m_voScoreNotify_OtherPlayer_MainMessage_Enemy_Text(NULL)
, m_voScoreNotify_OtherPlayer_MainMessage_Team_Text(NULL)
, m_voScoreNotify_OtherPlayer_LocalKilledCount_Text(NULL)
, m_voScoreNotify_OtherPlayer_KilledLocalCount_Text(NULL)
, m_voScoreNotify_OtherPlayer_Score(NULL)
, m_voScoreNotify_OtherPlayer_Score_Text(NULL)
, m_voScoreNotify_OtherPlayer_Score_Text_Overlay(NULL)
, m_voScoreNotify_Simple(NULL)
, m_voScoreNotify_Simple_MainMessage_Text(NULL)
, m_voScoreNotify_Simple_Score(NULL)
, m_voScoreNotify_Simple_Score_Text(NULL)
, m_voScoreNotify_Simple_Score_Text_Overlay(NULL)
, m_voMainScoreAnim(NULL)
, m_voScoreNumberAnim(NULL)
, m_pAsset(NULL)
, m_activeQueueMessageIdx(-1)
, m_queueFirstFreeIdx(0)
, m_frameIncrement(0.0f)
, m_messagesInQueue(0)
, m_curFrame(1)
{
	for( int i=0; i<HUD_MAX_SCORE_QUEUE_SIZE; ++i )
	{
		m_messageQueue.push_back(new SScoreMessage());
	}
}

CHUD_ScoreNotify::~CHUD_ScoreNotify()
{
	for( int i=0; i<HUD_MAX_SCORE_QUEUE_SIZE; ++i )
	{
		SAFE_DELETE( m_messageQueue[i] );
	}
}

void CHUD_ScoreNotify::Init( void )
{
	m_pAsset = GetAsset("ScoreNotify");

	HUD_FLASVAROBJ_REG( m_pAsset, "HUD_XPNotify", m_voXPNotify ); 
	HUD_FLASVAROBJ_REG( m_pAsset, "HUD_MajorNotify", m_voMajorEvents );
	HUD_FLASVAROBJ_REG( m_pAsset, "HUD_MinorNotify", m_voMinorNotify );

	// Player related score popup
	HUD_FLASVAROBJ_REG( m_pAsset, "HUD_ScoreNotify", m_voScoresRoot ); // The score notify parent, controls animation

	// Other player scores
	{
		HUD_FLASVAROBJ_REG( m_pAsset, "HUD_ScoreNotify.PlayerSCORES", m_voScoreNotify_OtherPlayer );
		HUD_FLASVAROBJ_REG( m_pAsset, "HUD_ScoreNotify.PlayerSCORES.PlayerName_Text_Container1", m_voScoreNotify_OtherPlayer_MainMessage_Enemy );
		HUD_FLASVAROBJ_REG( m_pAsset, "HUD_ScoreNotify.PlayerSCORES.PlayerName_Text_Container2", m_voScoreNotify_OtherPlayer_MainMessage_Team );
		HUD_FLASVAROBJ_REG( m_pAsset, "HUD_ScoreNotify.PlayerSCORES.PlayerName_Text_Container1.Text", m_voScoreNotify_OtherPlayer_MainMessage_Enemy_Text );
		HUD_FLASVAROBJ_REG( m_pAsset, "HUD_ScoreNotify.PlayerSCORES.PlayerName_Text_Container2.Text", m_voScoreNotify_OtherPlayer_MainMessage_Team_Text );

		// Kills/Deaths
		HUD_FLASVAROBJ_REG( m_pAsset, "HUD_ScoreNotify.PlayerSCORES.Deaths.Text", m_voScoreNotify_OtherPlayer_KilledLocalCount_Text );
		HUD_FLASVAROBJ_REG( m_pAsset, "HUD_ScoreNotify.PlayerSCORES.Kills.Text", m_voScoreNotify_OtherPlayer_LocalKilledCount_Text );

		// Score anim
		HUD_FLASVAROBJ_REG( m_pAsset, "HUD_ScoreNotify.PlayerSCORES.HUD_ScoreGetNotify", m_voScoreNotify_OtherPlayer_Score );
		HUD_FLASVAROBJ_REG( m_pAsset, "HUD_ScoreNotify.PlayerSCORES.HUD_ScoreGetNotify.Text_Container1.HUD_Score_Text.Text", m_voScoreNotify_OtherPlayer_Score_Text_Overlay );
		HUD_FLASVAROBJ_REG( m_pAsset, "HUD_ScoreNotify.PlayerSCORES.HUD_ScoreGetNotify.Text_Container2.HUD_Score_Text.Text", m_voScoreNotify_OtherPlayer_Score_Text );
	}

	// Non player scores
	{
		HUD_FLASVAROBJ_REG( m_pAsset, "HUD_ScoreNotify.SimpleSCORES", m_voScoreNotify_Simple );
		HUD_FLASVAROBJ_REG( m_pAsset, "HUD_ScoreNotify.SimpleSCORES.ScoreMessages_Container.HUD_ScoreEvents_Text.Text", m_voScoreNotify_Simple_MainMessage_Text );
		HUD_FLASVAROBJ_REG( m_pAsset, "HUD_ScoreNotify.SimpleSCORES.HUD_ScoreGetNotify", m_voScoreNotify_Simple_Score );
		HUD_FLASVAROBJ_REG( m_pAsset, "HUD_ScoreNotify.SimpleSCORES.HUD_ScoreGetNotify.Text_Container1.HUD_Score_Text.Text", m_voScoreNotify_Simple_Score_Text_Overlay );
		HUD_FLASVAROBJ_REG( m_pAsset, "HUD_ScoreNotify.SimpleSCORES.HUD_ScoreGetNotify.Text_Container2.HUD_Score_Text.Text", m_voScoreNotify_Simple_Score_Text );
	}

	m_voXPNotify->SetVisible(false);
	m_voMajorEvents->SetVisible(false);
	m_voMinorNotify->SetVisible(false);

	m_voScoresRoot->SetVisible(false);
}

void CHUD_ScoreNotify::PreDelete( void )
{
	// util references to other assets, i.e. one of the below - put here in case of ref-counting.
	m_voMainScoreAnim = NULL;
	m_voScoreNumberAnim = NULL;

	// Release flash
	HUD_FLASHOBJ_SAFERELEASE( m_voXPNotify );
	HUD_FLASHOBJ_SAFERELEASE( m_voMajorEvents );
	HUD_FLASHOBJ_SAFERELEASE( m_voMinorNotify );

	HUD_FLASHOBJ_SAFERELEASE( m_voScoresRoot );
	HUD_FLASHOBJ_SAFERELEASE( m_voScoreNotify_OtherPlayer );
	HUD_FLASHOBJ_SAFERELEASE( m_voScoreNotify_OtherPlayer_MainMessage_Enemy );
	HUD_FLASHOBJ_SAFERELEASE( m_voScoreNotify_OtherPlayer_MainMessage_Team );
	HUD_FLASHOBJ_SAFERELEASE( m_voScoreNotify_OtherPlayer_MainMessage_Enemy_Text );
	HUD_FLASHOBJ_SAFERELEASE( m_voScoreNotify_OtherPlayer_MainMessage_Team_Text );
	HUD_FLASHOBJ_SAFERELEASE( m_voScoreNotify_OtherPlayer_LocalKilledCount_Text );
	HUD_FLASHOBJ_SAFERELEASE( m_voScoreNotify_OtherPlayer_KilledLocalCount_Text );
	HUD_FLASHOBJ_SAFERELEASE( m_voScoreNotify_OtherPlayer_Score );
	HUD_FLASHOBJ_SAFERELEASE( m_voScoreNotify_OtherPlayer_Score_Text );
	HUD_FLASHOBJ_SAFERELEASE( m_voScoreNotify_OtherPlayer_Score_Text_Overlay );

	HUD_FLASHOBJ_SAFERELEASE( m_voScoreNotify_Simple );
	HUD_FLASHOBJ_SAFERELEASE( m_voScoreNotify_Simple_MainMessage_Text );
	HUD_FLASHOBJ_SAFERELEASE( m_voScoreNotify_Simple_Score );
	HUD_FLASHOBJ_SAFERELEASE( m_voScoreNotify_Simple_Score_Text_Overlay );
	HUD_FLASHOBJ_SAFERELEASE( m_voScoreNotify_Simple_Score_Text );
}

void CHUD_ScoreNotify::Update( float frameTime )
{
	if( m_activeQueueMessageIdx == -1 )
	{
		m_frameIncrement = 0.0f;
		return;
	}

	// do animation stuff
	const int messagesInQueue = m_messagesInQueue;
	float animFrameIncrement = 1.0f/frameTime;
	if( messagesInQueue < HUD_SCORE_QUEUE_SIZE_BEFORE_FAST_SCROLL )
	{
		animFrameIncrement *= HUD_SCORE_SINGLE_TIME_MULTIPLIER;
	}
	else
	{
		animFrameIncrement *= HUD_SCORE_MULTIPLE_TIME_MULTIPLIER;
	}

	float frameIncrement = m_frameIncrement;
	frameIncrement += animFrameIncrement;
	if( frameIncrement>1.0f )
	{
		frameIncrement -= 1.0f; // at 30fps this should 'catch up'
		const int curFrame = m_curFrame + 1;


		m_curFrame = curFrame;
		UpdateQueue( );
		SetGotoAndStop(); // uses m_curFrame, please keep after update
	}
	m_frameIncrement = frameIncrement;

	m_pAsset->Update( frameTime );
}

void CHUD_ScoreNotify::Draw( void )
{
	m_pAsset->Draw();
}

void CHUD_ScoreNotify::OnHUDEvent(const SHUDEvent& event)
{
	CRY_ASSERT( event.eventType == eHUDEvent_OnNewScore );
	const SGameRulesScoreInfo& scoreInfo = *(static_cast<SGameRulesScoreInfo*>(event.GetData(0).GetPtr()));
	NewScoreElement( scoreInfo );
}

void CHUD_ScoreNotify::NewScoreElement( const SGameRulesScoreInfo& scoreInfo )
{
	int messagesInQueue = m_messagesInQueue;

	CRY_ASSERT_MESSAGE( (/*notfull*/messagesInQueue < HUD_MAX_SCORE_QUEUE_SIZE && m_queueFirstFreeIdx != -1) || (/*full*/messagesInQueue >= HUD_MAX_SCORE_QUEUE_SIZE && m_queueFirstFreeIdx == -1), "HUD: should never happen!" );
	if( messagesInQueue >= HUD_MAX_SCORE_QUEUE_SIZE || m_queueFirstFreeIdx == -1 )
	{
		CryHUDWarning(VALIDATOR_MODULE_GAME, VALIDATOR_WARNING, "HUD: Score message queue full!" );
		return;
	}

	CryLogAlways ("CHUD_ScoreNotify::NewScoreElement rewarding %d points to local player", scoreInfo.score );

	if (scoreInfo.score)
	{
		SScoreMessage* newMessage = m_messageQueue[m_queueFirstFreeIdx];
		TScoreStringType& message = newMessage->message;
		newMessage->score = scoreInfo.score;

		CCCPOINT_IF(scoreInfo.score > 0, HUD_DisplayScoreIncrease);
		CCCPOINT_IF(scoreInfo.score < 0, HUD_DisplayScoreDecrease);

		CHUD* pHud = g_pGame->GetHUD();
		newMessage->victimId = 0;
		newMessage->usePlayerScore = false;
		switch( scoreInfo.type )
		{
		case EGRST_PlayerKill:                  
			message = pHud->LocalizeString("@ui_scorepopup_killed", HUDGetVictimName(scoreInfo.data.PlayerKill.victim).c_str(), NULL);
			newMessage->usePlayerScore = true;
			break;
		case EGRST_PlayerKillAssist:            
			message = pHud->LocalizeString("@ui_scorepopup_assist", HUDGetVictimName(scoreInfo.data.PlayerKill.victim).c_str(), NULL);
			newMessage->usePlayerScore = true;
			break;
		case EGRST_PlayerTeamKill:              
			message = pHud->LocalizeString("@ui_scorepopup_teamkill", HUDGetVictimName(scoreInfo.data.PlayerKill.victim).c_str(), NULL);
			newMessage->usePlayerScore = true;
			break;
		case EGRST_Suicide:                     message = pHud->LocalizeString("@ui_scorepopup_suicide");			break;
		case EGRST_CTF_FlagPickedUp:            message = pHud->LocalizeString("@ui_scorepopup_ctf_pickup");			break;
		case EGRST_CTF_FlagCompleted:           message = pHud->LocalizeString("@ui_scorepopup_ctf_completed");			break;
		case EGRST_CTF_FlagRetrieved:           message = pHud->LocalizeString("@ui_scorepopup_ctf_retrieved");			break;
		case EGRST_SingleHanded:                message = pHud->LocalizeString("@ui_scorepopup_singlehanded");			break;
		case EGRST_FlagAssist:                  message = pHud->LocalizeString("@ui_scorepopup_flagassist");			break;
		case EGRST_SelfDestructPrevention:      message = pHud->LocalizeString("@ui_scorepopup_selfdestructprevent", HUDGetVictimName(scoreInfo.data.PlayerKill.victim).c_str(), NULL);			break;
		case EGRST_CaptureObjectiveHeld:        message = pHud->LocalizeString("@ui_scorepopup_objective_held");			break;
		case EGRST_CaptureObjectiveTaken:       message = pHud->LocalizeString("@ui_scorepopup_objective_taken");			break;
		case EGRST_CaptureObjectiveCompleted:   message = pHud->LocalizeString("@ui_scorepopup_objective_complete");			break;
		case EGRST_AON_Win:                     message = pHud->LocalizeString("@ui_scorepopup_aon_win");			break;
		case EGRST_AON_Draw:                    message = pHud->LocalizeString("@ui_scorepopup_aon_draw");			break;
		case EGRST_CarryObjectiveTaken:         message = pHud->LocalizeString("@ui_scorepopup_objective_taken");			break;
		case EGRST_CarryObjectiveRetrieved:     message = pHud->LocalizeString("@ui_scorepopup_objective_retrieved");			break;
		case EGRST_CarryObjectiveCarrierKilled: message = pHud->LocalizeString("@ui_scorepopup_carrier_killed");			break;
		case EGRST_CarryObjectiveDefended:      message = pHud->LocalizeString("@ui_scorepopup_objective_defended");			break;
		case EGRST_CarryObjectiveCompleted:     message = pHud->LocalizeString("@ui_scorepopup_objective_complete");			break;
		case EGRST_CarryObjectiveHeld:          message = pHud->LocalizeString("@ui_scorepopup_objective_held");			break;
		case EGRST_BombTheBaseCompleted:        message = pHud->LocalizeString("@ui_scorepopup_btb_complete");			break;
		case EGRST_KingOfTheHillObjectiveHeld:  message = pHud->LocalizeString("@ui_scorepopup_objective_held");			break;
		}

		CRY_ASSERT(message.empty() == false);

		if( newMessage->usePlayerScore )
		{
			CRY_ASSERT(scoreInfo.data.PlayerKill.victim);
			newMessage->victimId = scoreInfo.data.PlayerKill.victim;
		}

		const char * localised = (message.size() && message.c_str()[0] == '@') ? pHud->LocalizeString(message.c_str()) : message.c_str();
		message = localised;

		messagesInQueue += 1;
		m_messagesInQueue = messagesInQueue;
		if( messagesInQueue < HUD_MAX_SCORE_QUEUE_SIZE )
		{
			const unsigned int curIdx = m_queueFirstFreeIdx;
			unsigned int nextIdx = 0;
			if( curIdx+1 < HUD_MAX_SCORE_QUEUE_SIZE )
			{
				nextIdx = curIdx+1;
			}

			m_queueFirstFreeIdx = nextIdx; // nextIdx should always be free.

			if( messagesInQueue == 1 ) // 1st new one in queue
			{
				m_activeQueueMessageIdx = curIdx;
				SetData( );
			}
		}
		else // messagesInQueue > HUD_MAX_SCORE_QUEUE_SIZE
		{
			m_queueFirstFreeIdx = -1;
		}
	}
}

void CHUD_ScoreNotify::UpdateQueue( void )
{
	if( m_curFrame > HUD_SCORE_NUMBER_OF_ANIM_FRAMES )
	{
		unsigned int messagesInQueue = m_messagesInQueue-1;

		if( m_queueFirstFreeIdx==-1 )
		{
			m_queueFirstFreeIdx = m_activeQueueMessageIdx;
		}

		if( messagesInQueue <= 0 )
		{ // no messages
			m_activeQueueMessageIdx = -1;
		}
		else
		{ // messages in queue to display
			// Get next idx
			const unsigned int curIdx = m_activeQueueMessageIdx;	
			unsigned int nextIdx = 0;
			if( curIdx+1 < HUD_MAX_SCORE_QUEUE_SIZE )
			{
				nextIdx = curIdx+1;
			}
			m_activeQueueMessageIdx = nextIdx;


			// Todo update next in chain.
		}

		m_messagesInQueue = messagesInQueue;

		SetData();
	}
}

void CHUD_ScoreNotify::SetData( void )
{
	m_curFrame = 1;
	CRY_ASSERT( ((m_messagesInQueue==0) && (m_activeQueueMessageIdx<0)) || ((m_messagesInQueue>0) && (m_activeQueueMessageIdx>=0)) );
	if( m_activeQueueMessageIdx < 0  )
	{
		m_voScoresRoot->SetVisible(false);
		return;
	}

	SScoreMessage* activeMessageData = m_messageQueue[m_activeQueueMessageIdx];

	// Force show on the root MC
	m_voScoresRoot->SetVisible(true);

	// Get the score as string
	char sz_score[8];
	sprintf( sz_score, "%s%d", (activeMessageData->score==0 ? "" : (activeMessageData->score < 0 ? "-" : "+") ), activeMessageData->score);

	// decide whether we're using the player related score or not.
	if( activeMessageData->usePlayerScore )
	{
		// Get Data

		char sz_timesKilledLocal[8];
		char sz_timesKilledByLocal[8];
		uint8 timesKilledLocal = 0;
		uint8 timesKilledByLocal = 0;

		CGameRules* pGameRules = g_pGame->GetGameRules();
		CRY_ASSERT(pGameRules);
		IGameRulesPlayerStatsModule*  pPlayStatsMo = pGameRules->GetPlayerStatsModule();
		CRY_ASSERT(pPlayStatsMo); // player stats should always exist.
		EntityId localEntId = g_pGame->GetIGameFramework()->GetClientActorId();
		CActor* pActor = static_cast<CActor*>(g_pGame->GetIGameFramework()->GetClientActor());
		const bool isFriendly = pActor ? (pActor->IsFriendlyEntity( activeMessageData->victimId ) > 0) : false;

		// Get the stats for the two players involved
		const SGameRulesPlayerStat* clientStats = pPlayStatsMo->GetPlayerStats( localEntId );
		const SGameRulesPlayerStat* killedPlayerStats = pPlayStatsMo->GetPlayerStats( g_pGame->GetIGameFramework()->GetClientActorId() );
		CRY_ASSERT_MESSAGE( clientStats && killedPlayerStats, "HUD: Playerstats not availiable! Please fix me." );
		if( clientStats && killedPlayerStats )
		{
			timesKilledLocal = killedPlayerStats->GetTimesKilledPlayer(localEntId);
			timesKilledByLocal = clientStats->GetTimesKilledPlayer(activeMessageData->victimId);

			sprintf( sz_timesKilledLocal, "%d", timesKilledByLocal );
			sprintf( sz_timesKilledByLocal, "%d", timesKilledLocal );
		}
		else
		{
			sprintf( sz_timesKilledLocal, "???" );
			sprintf( sz_timesKilledByLocal, "???" );
		}

		// Update Flash

		m_voScoreNotify_Simple->SetVisible(false);
		m_voScoreNotify_OtherPlayer->SetVisible(true);

		IFlashVariableObject* messageToShow = NULL;
		IFlashVariableObject* messageToHide = NULL;
		IFlashVariableObject* messageToUpdate = NULL;
		if( isFriendly )
		{ // Team kill
			messageToHide = m_voScoreNotify_OtherPlayer_MainMessage_Enemy;
			messageToShow = m_voScoreNotify_OtherPlayer_MainMessage_Team;
			messageToUpdate = m_voScoreNotify_OtherPlayer_MainMessage_Team_Text;
		}
		else
		{ // Enemy kill
			messageToShow = m_voScoreNotify_OtherPlayer_MainMessage_Enemy;
			messageToHide = m_voScoreNotify_OtherPlayer_MainMessage_Team;
			messageToUpdate = m_voScoreNotify_OtherPlayer_MainMessage_Enemy_Text;
		}

		messageToShow->SetVisible(true);
		messageToHide->SetVisible(false);
		messageToUpdate->SetText(activeMessageData->message.c_str());

		m_voScoreNotify_OtherPlayer_Score_Text_Overlay->SetText( sz_score );
		m_voScoreNotify_OtherPlayer_Score_Text->SetText( sz_score );

		m_voScoreNotify_OtherPlayer_LocalKilledCount_Text->SetText(sz_timesKilledByLocal);
		m_voScoreNotify_OtherPlayer_KilledLocalCount_Text->SetText(sz_timesKilledLocal);

		m_voMainScoreAnim = m_voScoreNotify_OtherPlayer;
		m_voScoreNumberAnim = m_voScoreNotify_OtherPlayer_Score;
	}
	else
	{
		m_voScoreNotify_OtherPlayer->SetVisible(false);

		m_voScoreNotify_Simple->SetVisible(true);
		m_voScoreNotify_Simple_MainMessage_Text->SetText(activeMessageData->message.c_str());
		m_voScoreNotify_Simple_Score_Text_Overlay->SetText(sz_score);
		m_voScoreNotify_Simple_Score_Text->SetText(sz_score);

		m_voMainScoreAnim = m_voScoreNotify_Simple;
		m_voScoreNumberAnim = m_voScoreNotify_Simple_Score;
	}

	SetGotoAndStop(); // m_curframe is set at the start of this function.
}

void CHUD_ScoreNotify::SetGotoAndStop( void )
{
	CRY_ASSERT(m_voMainScoreAnim && m_voScoreNumberAnim);

	// update flash animations/time-lines
	m_voMainScoreAnim->GotoAndStop(m_curFrame);
	m_voScoreNumberAnim->GotoAndStop(m_curFrame);

// 	m_voScoreNotify_Simple->GotoAndStop(m_curFrame);
// 	m_voScoreNotify_Simple_Score->GotoAndStop(m_curFrame);
// 	m_voScoreNotify_OtherPlayer->GotoAndStop(m_curFrame);
// 	m_voScoreNotify_OtherPlayer_Score->GotoAndStop(m_curFrame);
}

#if ENABLE_HUD_EXTRA_DEBUG
void CHUD_ScoreNotify::CMDTriggerScore( IConsoleCmdArgs *pArgs )
{
	SGameRulesScoreInfo si( EGRST_PlayerKill, 10 );
	si.AttachVictim(0);

	const int scoreInc = 10;

	SHUDEvent scoreHudEvent(eHUDEvent_OnNewScore);
	scoreHudEvent.AddData(&si);
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_PlayerKillAssist;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_PlayerTeamKill;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_CTF_FlagPickedUp;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_CTF_FlagCompleted;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_CTF_FlagRetrieved;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_Suicide;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_SingleHanded;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_FlagAssist;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_SelfDestructPrevention;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_CaptureObjectiveHeld;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_CaptureObjectiveTaken;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_CaptureObjectiveCompleted;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_CaptureObjectivesDefended;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_AON_Win;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_AON_Draw;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_CarryObjectiveTaken;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_CarryObjectiveRetrieved;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_CarryObjectiveCarrierKilled;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_CarryObjectiveDefended;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_CarryObjectiveCompleted;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent); 

	si.type = EGRST_CarryObjectiveHeld;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_BombTheBaseCompleted;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);

	si.type = EGRST_KingOfTheHillObjectiveHeld;
	si.score += scoreInc;
	CHUD::CallEvent(scoreHudEvent);
}
#endif // ENABLE_HUD_EXTRA_DEBUG
