#ifndef ___HUD_SCORENOTIFY___
#define ___HUD_SCORENOTIFY___

#include "HUD/HUDObject.h"

#include "Utility/CryFixedArray.h"

////////////////////////////////////////////////////////////////////

#define HUD_MAX_SCORE_QUEUE_SIZE 16

#define HUD_SCORE_QUEUE_SIZE_BEFORE_FAST_SCROLL (int)3
#define HUD_SCORE_SINGLE_TIME_MULTIPLIER (float)0.5f
#define HUD_SCORE_MULTIPLE_TIME_MULTIPLIER (float)2.0f

#define HUD_SCORE_NUMBER_OF_ANIM_FRAMES (int)100

////////////////////////////////////////////////////////////////////

struct SGameRulesScoreInfo;

////////////////////////////////////////////////////////////////////

class CHUD_ScoreNotify : public CHUDObject
{
private : // types

	typedef CryFixedStringT<64> TScoreStringType;

	struct SScoreMessage{
		TScoreStringType message;
		EntityId         victimId;
		int              score;
		bool             usePlayerScore;
		SScoreMessage()
		: message("")
		, victimId(0)
		, score(0)
		{
			// ...
		}
	};
	typedef CryFixedArray<SScoreMessage*, HUD_MAX_SCORE_QUEUE_SIZE> TScoreMessageBuffer;

public : // public interface

	CHUD_ScoreNotify();
	~CHUD_ScoreNotify();

	//CHUDObject
	virtual void Init( void );
	virtual void Draw( void );
	virtual void Update( float frameTime );
	virtual void OnHUDEvent(const SHUDEvent& event);
	virtual void PreDelete( void );
	//~CHUDObject

#if ENABLE_HUD_EXTRA_DEBUG
	// Console cmds
	static void CMDTriggerScore( IConsoleCmdArgs *pArgs );
#endif // ENABLE_HUD_EXTRA_DEBUG

protected : // private funcs

	void NewScoreElement( const SGameRulesScoreInfo& scoreInfo );
	void UpdateQueue( void );
	void SetData( void );
	void SetGotoAndStop( void );
protected : // member vars

	TScoreMessageBuffer      m_messageQueue;

	IFlashVariableObject* m_voXPNotify;
	IFlashVariableObject* m_voMajorEvents;
	IFlashVariableObject* m_voMinorNotify;

	IFlashVariableObject* m_voScoresRoot;

	// Other player events
	IFlashVariableObject* m_voScoreNotify_OtherPlayer;
	IFlashVariableObject* m_voScoreNotify_OtherPlayer_MainMessage_Enemy;
	IFlashVariableObject* m_voScoreNotify_OtherPlayer_MainMessage_Team;
	IFlashVariableObject* m_voScoreNotify_OtherPlayer_MainMessage_Enemy_Text;
	IFlashVariableObject* m_voScoreNotify_OtherPlayer_MainMessage_Team_Text;
	IFlashVariableObject* m_voScoreNotify_OtherPlayer_LocalKilledCount_Text;
	IFlashVariableObject* m_voScoreNotify_OtherPlayer_KilledLocalCount_Text;
	IFlashVariableObject* m_voScoreNotify_OtherPlayer_Score;
	IFlashVariableObject* m_voScoreNotify_OtherPlayer_Score_Text;
	IFlashVariableObject* m_voScoreNotify_OtherPlayer_Score_Text_Overlay;

	// Non-player scores
	IFlashVariableObject* m_voScoreNotify_Simple;
	IFlashVariableObject* m_voScoreNotify_Simple_MainMessage_Text;
	IFlashVariableObject* m_voScoreNotify_Simple_Score;
	IFlashVariableObject* m_voScoreNotify_Simple_Score_Text;
	IFlashVariableObject* m_voScoreNotify_Simple_Score_Text_Overlay;

	// Time line animations
	IFlashVariableObject* m_voMainScoreAnim;
	IFlashVariableObject* m_voScoreNumberAnim; 

	IHUDAsset*            m_pAsset;
	int                   m_activeQueueMessageIdx;
	int                   m_queueFirstFreeIdx;
	float                 m_frameIncrement;
	unsigned int          m_messagesInQueue;
	unsigned int          m_curFrame;

};

#endif // ___HUD_SCORENOTIFY___
