#ifndef __HUD_TAGNAMES_H__
#define __HUD_TAGNAMES_H__

#include "HUD/HUDObject.h"
#include "HUD/HUD.h"
#include "Utility/CryFixedArray.h"

#include "HUD/UI/UITagNames.h" // TODO : Remove

#include <IFlashPlayer.h>

//////////////////////////////////////////////////////////////////////////

class CHUD_Tagnames : public CHUDObject, public CTagnameCommon
{
private :

	struct STagInfo
	{
		enum ETagInfoFrame{
			eTIF_Friendly = 1,
			eTIF_Enemy    = 2,
			eTIF_Dead     = 3,
		};

		enum ETagInfoUpdateFlags{
			eTIUF_None   = 0,
			eTIUF_Frame  = BIT(0),
			eTIUF_Health = BIT(1),
			eTIUF_Name   = BIT(2),
			eTIUF_HealthVisiblity = BIT(3),
		};

		struct SFlashTagname
		{
			IFlashVariableObject* vo_name;
			IFlashVariableObject* vo_healthbar;

			SFlashTagname();

			// should only be called when the entity is added/removed.
			void SetName( const char* name );

			// Should only be called when the health has changed.
			void SetHealth( const int healthPercent );

			// Should only be called when showing the health.
			void SetHealthVisible( const bool show );

			// Called when depths are swapped.
			void ZSwapWith( SFlashTagname& inout_tn )
			{
				std::swap( vo_name, inout_tn.vo_name );
				std::swap( vo_healthbar, inout_tn.vo_healthbar );
			}
		};

		// ----

		STagInfo();
		~STagInfo();

		void Init(IHUDAsset* pAsset, const int tagidx);
		void Clear( void );
		void Update( const float frameDeltaTime, const EntityId lookingAt );
		void PostZSortUpdate( void );
		void SetVisible( const bool visible );

		// Swap out the references to the flash objects used for rendering
		// for faked Z-depths in flash.
		// NB: It may be faster to use flash itself to do this; '_depth' or similar.
		void ZSwapWith( const int depth, STagInfo& inout_ti );

	private :
		void Set(const EntityId entityId, const bool dead, const bool friendly, const Vec3& pos, const float size, const float distance, const bool visible, const int healthPercentconst, const bool healthVisible );
		bool CanSee( void );
		void UpdateLocks( const float frameDelatTime, const EntityId lookingAt );
		void ConvertScreenToFlashSpace( Vec3& inout_pos ) const;

		// ----

		static const uint8   k_numberOfTagnameFrames = 3;

	public :
		SFlashTagname         vos_tagnames[k_numberOfTagnameFrames]; // flash pointer to each frame's data one each for friend, enemy, dead.
		SFlashDisplayInfo     di_tagname; // pos, alpha, size, etc. in scaleform terms.
		Vec3                  m_pos;      // pos in flash-screen space.
		IFlashVariableObject* vo_tagname; // flash object to apply di_tagname's properties to 
		ETagInfoFrame         m_curFrame; // which frame are we one.
		EntityId              m_entityId; // Entity begin tracked. Owns this data
		//float                 m_size;     // Todo if we implement scaling with distance (deprecated)
		float                 m_distance; // distance of entity from locl player.
		float                 m_timeUntilIgnoreEnds;
		int                   m_health;
		float                 m_timeUntilLock;      // i.e. only just seen.
		float                 m_timeUntilLockLost;  // i.e. started and ticked whenever the tracked enitity not look at.

		// flash update flags and state
		int8     m_flags;
		int8     m_curDepth;
		int8     m_lastDepth;

		CRY_TODO( 11, 02, 2010, "HUD: Flagise or bit compress these bools" );
		bool     m_friendly;
		bool     m_dead;
		bool     m_visible;        // currently being drawn
		bool     m_healthVisible;  // currently being drawn
		bool     m_ignore;         // carrying an objective
		bool     m_locked;         // enemy has been identified draw.
		bool     m_canSee;         // can see player.
		bool     m_drawStatus;     // draw health bars etc.
	};

public :

	CHUD_Tagnames();
	~CHUD_Tagnames();

	//CHUDObject
	virtual void Init( void );
	virtual void Update( float frameTime );
	virtual void Draw( );
	virtual void OnHUDEvent(const SHUDEvent& event);
	//~CHUDObject

	//CTagnameCommon
	virtual void ZSort( void );
	virtual void IgnoreEntity( EntityId entity_id, bool ignore, float time );
	//~CTagnameCommon

	void      RecalcScaleFactor( void );
	const int GetTagIdxForEntity( const EntityId enittyId );

	void      TrackEntity( const EntityId remotePlayerId );
	void      UntrackEntity( const EntityId remotePlayerId );

protected :

	STagInfo            m_tagInfo[HUD_MAX_TAGNAMES];
	int                 m_zsortedTagInfos[HUD_MAX_TAGNAMES];
	int                 m_zsortedTagInfosPrev[HUD_MAX_TAGNAMES];
	EntityId            m_ignoreEnts[HUD_MAX_TAGNAMES];
	SFlashDisplayInfo   m_tagnameRootDI;
	int                 m_tagsCount;

	EntityId            m_lookAt;
	EntityId            m_enemyToLockOnTo;
	float               m_timeLockedOnEnemy;

	float               m_scaleFactor;
};

#endif // __HUD_TAGNAMES_H__
