/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2010.
-------------------------------------------------------------------------
Description: 

-------------------------------------------------------------------------
History:
- 23:2:2010	17:14 : Created by David Ramos
*************************************************************************/
#pragma once
#ifndef __HIT_DEATH_REACTIONS_DEFS_H
#define __HIT_DEATH_REACTIONS_DEFS_H

#include <CryExtension/CrySharedPtr.h>	// cryshared_ptr
#include <ScriptHelpers.h>							// SmartScriptTable
#include <IAgent.h>											// EStance enumeration
#include <CryCharAnimationParams.h>			// anim flags


//	Utility enum for specifying cardinal directions
enum ECardinalDirection
{
	eCD_Invalid = -1,

	// "90" directions
	eCD_Forward,
	eCD_Back,
	eCD_Left,
	eCD_Right,

	// "180" direction
	eCD_Ahead,
	eCD_Behind,
	eCD_LeftSide,
	eCD_RightSide,
};

// Utility typedefs
typedef SmartScriptTable	ScriptTablePtr;
typedef int								ReactionId;

// 
namespace
{
	const char REACTION_ID[] = "__reactionId";
	const ReactionId INVALID_REACTION_ID = 0;
	const unsigned char NO_COLLISION_REACTION = 0;
	const uint32 DEFAULT_REACTION_ANIM_FLAGS = CA_FORCE_SKELETON_UPDATE | CA_DISABLE_MULTILAYER | CA_REPEAT_LAST_KEY | CA_ALLOW_ANIM_RESTART;
}

//////////////////////////////////////////////////////////////////////////
// Struct holding all the reaction parameters
//////////////////////////////////////////////////////////////////////////
struct SReactionParams
{
	typedef std::vector<int> AnimIDContainer;

	struct SReactionAnim
	{
		SReactionAnim() { Reset(); }

		void Reset();

		AnimIDContainer animIDs;     // List of animation IDs
		int							iLayer;
		uint32					animFlags;
		bool						bAdditive;
	};

	struct SAnimGraphReaction
	{
		struct SVariationData
		{
			SVariationData() {}
			SVariationData(const char* szName, const char* szValue) : sName(szName), sValue(szValue) {}


			string sName;
			string sValue;
		};
		typedef std::vector<SVariationData> VariationsContainer;

		void Reset();

		string							sAGInputValue;				// Value that will be set in the signal input on the Animation Graph
		VariationsContainer	variations;						// List of all the variations
	};

	typedef VectorSet<int> IdContainer;
	typedef VectorSet<EStance> StanceContainer;

	enum Flags
	{
		OrientateToHitDir		= BIT(0),
	};

	SReactionParams() : fMinimumSpeedAllowed(0.0f), fMaximumSpeedAllowed(std::numeric_limits<float>::max()), 
		fMinimumDamageAllowed(0.0f), fMaximumDamageAllowed(std::numeric_limits<float>::max()), fProbability(1.0f), 
		shotOrigin(eCD_Invalid), movementDir(eCD_Invalid), orientationSnapAngle(0), reactionOnCollision(NO_COLLISION_REACTION), 
		flags(0), bPauseAI(true), bAllowOnlyWhenUsingMountedItems(false), destructibleEvent(0) {}
	void Reset();

	void GetMemoryUsage(ICrySizer * s) const {}

	string							sCustomValidationFunc;// Name of the customized validation func (if present)
	string							sCustomExecutionFunc;	// Name of the customized execution func (if present)
	string							sCustomAISignal;		// Signal to send to the actor's AI when reaction starts playing
	float								fMinimumSpeedAllowed;	// Minimum speed of the actor receiving the hit for this reaction to be valid
	float								fMaximumSpeedAllowed; // Maximum speed of the actor receiving the hit for this reaction to be valid
	IdContainer					allowedPartIds;				// set of partIds where the hit is allowed to impact for this reaction to be valid
	ECardinalDirection	shotOrigin;						// cardinal direction where the shot came from
	ECardinalDirection	movementDir;					// cardinal direction the player is moving towards
	float								fProbability;					// decimal percentage of probability for this reaction to happen
	StanceContainer			allowedStances;				// this reaction is only allowed on these stances
	IdContainer					allowedHitTypes;			// this reaction is only allowed from one of these hit types
	IdContainer					allowedProjectiles;		// this reaction is only allowed when caused by one of these projectile class Ids
	IdContainer					allowedWeapons;				// this reaction is only allowed when caused by one of these weapon class Ids
	float								fMinimumDamageAllowed;	// Minimum damage for this reaction to be valid
	float								fMaximumDamageAllowed; // Maximum damage for this reaction to be valid
	bool								bPauseAI;							// while playing this reaction the AI is disabled
	bool								bAllowOnlyWhenUsingMountedItems;	// If TRUE, the reaction will only be valid if the guy is using a mounted item, if FALSE, it will be valid anytime
	unsigned int				destructibleEvent;		// Last destructible event CRC32 generated by the destructible parts system

	SAnimGraphReaction	agReaction;						// Parameters for the anim-graph based reaction
	SReactionAnim				reactionAnim;					// Parameters for the reaction anim used for the default execution

	ScriptTablePtr			reactionScriptTable;	// Holds the pointer to the script table holding the reaction information
	float								orientationSnapAngle;	// The angle in radians that the animation ought to play in relative to the hit direction
	unsigned char				reactionOnCollision;	// Specifies if we want reaction on collision or not, and which reaction (collisions on death reactions are always ragdoll)
	uint8								flags;								
};

// SReactionParams related typedefs
typedef std::vector<SReactionParams>						ReactionsContainer;
typedef cryshared_ptr<ReactionsContainer>				ReactionsContainerPtr;
typedef cryshared_ptr<const ReactionsContainer>	ReactionsContainerConstPtr;


#endif // __HIT_DEATH_REACTIONS_DEFS_H