//************************************************************************
//
// LCDProgressBar.h
//
// The CLCDProgressBar class draws a progress bar onto the LCD.
// 
// Logitech LCD SDK
//
// Copyright 2005 Logitech Inc.
//************************************************************************

#ifndef _LCDPROGRESSBAR_H_INCLUDED_ 
#define _LCDPROGRESSBAR_H_INCLUDED_ 

#ifdef USE_G15_LCD

#include "LCDBase.h"

typedef struct RANGE
{
    int nMin;
    int nMax;

}RANGE, *LPRANGE;

enum ePROGRESS_STYLE { STYLE_FILLED, STYLE_CURSOR, STYLE_DASHED_CURSOR };

class CLCDProgressBar : public CLCDBase
{
public:
	enum ePROGRESS_STYLE { STYLE_FILLED, STYLE_CURSOR, STYLE_DASHED_CURSOR };
    
    CLCDProgressBar();
    virtual ~CLCDProgressBar();

    // CLCDBase
    virtual HRESULT Initialize(void);
    virtual void OnDraw(CLCDGfx &rGfx);
    virtual void ResetUpdate(void);
    
    // CLCDProgressBar
    virtual void SetRange(int nMin, int nMax);
    virtual void SetRange(RANGE& Range);
    virtual RANGE& GetRange(void);
    virtual float SetPos(float fPos);
    virtual float GetPos(void);
    virtual void EnableCursor(BOOL bEnable);
	virtual void SetProgressStyle(ePROGRESS_STYLE eStyle);

protected:
    float Scalef(float fFromMin, float fFromMax,
                 float fToMin, float fToMax, float fFromValue);
    int Scale(int nFromMin, int nFromMax,
              int nToMin, int nToMax, int nFromValue);

private:
    RANGE m_Range;
    float m_fPos;
    ePROGRESS_STYLE m_eStyle;
    HBRUSH m_hBrush;
	HPEN m_hPen;
    int m_nCursorWidth;
};


#endif//USE_G15_LCD

#endif // !_LCDPROGRESSBAR_H_INCLUDED_ 

//** end of LCDProgressBar.h *********************************************
