////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek, 1999-2010.
// -------------------------------------------------------------------------
//  File name:   LookAim_Helper.h
//  Version:     v1.00
//  Created:     25/01/2010 by Sven Van Soom
//  Description: Helper class for setting up and updating Looking and Aiming
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////
#pragma once

#ifndef _LOOKAIM_HELPER_H_
#define _LOOKAIM_HELPER_H_

#include <ICryAnimation.h>
#include "Animation/PoseModifier/LookAtSimple.h"

class CPlayer;


class CLookAim_Helper
{
public:
	CLookAim_Helper();

	void UpdateLook(CPlayer* pPlayer, ICharacterInstance* pCharacter, bool bEnabled, f32 FOV, const Vec3& LookAtTarget,const f32 *customBlends = NULL);

	void Reset()
	{
		m_initialized = false;
	}

private:

	void Init(CPlayer* pPlayer, ICharacterInstance* pCharacter);

	bool m_initialized;
	bool m_canUseLookAtComplex;
	bool m_canUseLookAtSimple;

	cryshared_ptr<AnimPoseModifier::CLookAtSimple> m_lookAtSimple;
	float m_lookAtWeight; // only used for LookAtSimple now as old LookIK also does this
	float m_lookAtFadeInSpeed; // only used for LookAtSimple now as old LookIK also does this
	float m_lookAtFadeOutSpeed; // only used for LookAtSimple now as old LookIK also does this
	Vec3 m_lookAtInterpolatedTargetGlobal; // only used for LookAtSimple now as old LookIK also does this
	Vec3 m_lookAtTargetRate; // for generating smooth motion
	Vec3 m_lookAtTargetGlobal; // only used for LookAtSimple now as old LookIK also does this
	float m_lookAtTargetSmoothTime; // only used for LookAtSimple now as old LookIK also does this
};

#endif