// Automatically generated by PacketGenerator
#ifndef __clientpacket_h__
#define __clientpacket_h__

#pragma once

#include "../ClientServerCommon.h"
#include "PacketCommon.h"

namespace Packet
{
	enum ClientPacketType
	{
		eCP_CLogin,
		eCP_CMyPlayerInfo,
		eCP_COtherPlayerInfo,
		eCP_CMonsterInfo,
		eCP_CMovement,
		eCP_CChat,
		eCP_Max,
	};

	struct Pkt_CLogin
	{
		string username;
		string password;
	};

	struct Pkt_CMyPlayerInfo
	{
		int serial;
	};

	struct Pkt_COtherPlayerInfo
	{
		int dummy;
	};

	struct Pkt_CMonsterInfo
	{
		int dummy;
	};

	struct Pkt_CMovement
	{
		SPosition src;
		SPosition dst;
	};

	struct Pkt_CChat
	{
		string message;
	};

	//////////////////////////////////////////////////////////////////////////
	// Pkt_CLogin
	//////////////////////////////////////////////////////////////////////////
	template<> inline uint32 SizeT(const Pkt_CLogin& data)
	{
		return PacketHeaderSize+SizeT(data.username)+SizeT(data.password);
	}

	template<> inline uint32 SizeT(Pkt_CLogin& data)
	{
		return SizeT((const Pkt_CLogin&)data);
	}

	template<> inline bool SerializeT(const Pkt_CLogin& src, char* buffer, int& offset, int bufferLen)
	{
		WriteHeader(eCP_CLogin, SizeT(src), buffer, offset, bufferLen);
		SerializeT(src.username, buffer, offset, bufferLen);
		SerializeT(src.password, buffer, offset, bufferLen);
		return true;
	}

	template<> inline bool DeserializeT(Pkt_CLogin& dst, const char* buffer, int& offset, int bufferLen)
	{
		SkipHeader(buffer, offset, bufferLen);
		DeserializeT(dst.username, buffer, offset, bufferLen);
		DeserializeT(dst.password, buffer, offset, bufferLen);
		return true;
	}

	//////////////////////////////////////////////////////////////////////////
	// Pkt_CMyPlayerInfo
	//////////////////////////////////////////////////////////////////////////
	template<> inline uint32 SizeT(const Pkt_CMyPlayerInfo& data)
	{
		return PacketHeaderSize+SizeT(data.serial);
	}

	template<> inline uint32 SizeT(Pkt_CMyPlayerInfo& data)
	{
		return SizeT((const Pkt_CMyPlayerInfo&)data);
	}

	template<> inline bool SerializeT(const Pkt_CMyPlayerInfo& src, char* buffer, int& offset, int bufferLen)
	{
		WriteHeader(eCP_CMyPlayerInfo, SizeT(src), buffer, offset, bufferLen);
		SerializeT(src.serial, buffer, offset, bufferLen);
		return true;
	}

	template<> inline bool DeserializeT(Pkt_CMyPlayerInfo& dst, const char* buffer, int& offset, int bufferLen)
	{
		SkipHeader(buffer, offset, bufferLen);
		DeserializeT(dst.serial, buffer, offset, bufferLen);
		return true;
	}

	//////////////////////////////////////////////////////////////////////////
	// Pkt_COtherPlayerInfo
	//////////////////////////////////////////////////////////////////////////
	template<> inline uint32 SizeT(const Pkt_COtherPlayerInfo& data)
	{
		return PacketHeaderSize+SizeT(data.dummy);
	}

	template<> inline uint32 SizeT(Pkt_COtherPlayerInfo& data)
	{
		return SizeT((const Pkt_COtherPlayerInfo&)data);
	}

	template<> inline bool SerializeT(const Pkt_COtherPlayerInfo& src, char* buffer, int& offset, int bufferLen)
	{
		WriteHeader(eCP_COtherPlayerInfo, SizeT(src), buffer, offset, bufferLen);
		SerializeT(src.dummy, buffer, offset, bufferLen);
		return true;
	}

	template<> inline bool DeserializeT(Pkt_COtherPlayerInfo& dst, const char* buffer, int& offset, int bufferLen)
	{
		SkipHeader(buffer, offset, bufferLen);
		DeserializeT(dst.dummy, buffer, offset, bufferLen);
		return true;
	}

	//////////////////////////////////////////////////////////////////////////
	// Pkt_CMonsterInfo
	//////////////////////////////////////////////////////////////////////////
	template<> inline uint32 SizeT(const Pkt_CMonsterInfo& data)
	{
		return PacketHeaderSize+SizeT(data.dummy);
	}

	template<> inline uint32 SizeT(Pkt_CMonsterInfo& data)
	{
		return SizeT((const Pkt_CMonsterInfo&)data);
	}

	template<> inline bool SerializeT(const Pkt_CMonsterInfo& src, char* buffer, int& offset, int bufferLen)
	{
		WriteHeader(eCP_CMonsterInfo, SizeT(src), buffer, offset, bufferLen);
		SerializeT(src.dummy, buffer, offset, bufferLen);
		return true;
	}

	template<> inline bool DeserializeT(Pkt_CMonsterInfo& dst, const char* buffer, int& offset, int bufferLen)
	{
		SkipHeader(buffer, offset, bufferLen);
		DeserializeT(dst.dummy, buffer, offset, bufferLen);
		return true;
	}

	//////////////////////////////////////////////////////////////////////////
	// Pkt_CMovement
	//////////////////////////////////////////////////////////////////////////
	template<> inline uint32 SizeT(const Pkt_CMovement& data)
	{
		return PacketHeaderSize+SizeT(data.src)+SizeT(data.dst);
	}

	template<> inline uint32 SizeT(Pkt_CMovement& data)
	{
		return SizeT((const Pkt_CMovement&)data);
	}

	template<> inline bool SerializeT(const Pkt_CMovement& src, char* buffer, int& offset, int bufferLen)
	{
		WriteHeader(eCP_CMovement, SizeT(src), buffer, offset, bufferLen);
		SerializeT(src.src, buffer, offset, bufferLen);
		SerializeT(src.dst, buffer, offset, bufferLen);
		return true;
	}

	template<> inline bool DeserializeT(Pkt_CMovement& dst, const char* buffer, int& offset, int bufferLen)
	{
		SkipHeader(buffer, offset, bufferLen);
		DeserializeT(dst.src, buffer, offset, bufferLen);
		DeserializeT(dst.dst, buffer, offset, bufferLen);
		return true;
	}

	//////////////////////////////////////////////////////////////////////////
	// Pkt_CChat
	//////////////////////////////////////////////////////////////////////////
	template<> inline uint32 SizeT(const Pkt_CChat& data)
	{
		return PacketHeaderSize+SizeT(data.message);
	}

	template<> inline uint32 SizeT(Pkt_CChat& data)
	{
		return SizeT((const Pkt_CChat&)data);
	}

	template<> inline bool SerializeT(const Pkt_CChat& src, char* buffer, int& offset, int bufferLen)
	{
		WriteHeader(eCP_CChat, SizeT(src), buffer, offset, bufferLen);
		SerializeT(src.message, buffer, offset, bufferLen);
		return true;
	}

	template<> inline bool DeserializeT(Pkt_CChat& dst, const char* buffer, int& offset, int bufferLen)
	{
		SkipHeader(buffer, offset, bufferLen);
		DeserializeT(dst.message, buffer, offset, bufferLen);
		return true;
	}

	//////////////////////////////////////////////////////////////////////////
	// ClientPacketHandler
	//////////////////////////////////////////////////////////////////////////
	class ClientPacketHandler
	{
	public:
		ClientPacketHandler() {}
		virtual ~ClientPacketHandler() {}

		virtual void Handle(const Pkt_CLogin& pkt) {};
		virtual void Handle(const Pkt_CMyPlayerInfo& pkt) {};
		virtual void Handle(const Pkt_COtherPlayerInfo& pkt) {};
		virtual void Handle(const Pkt_CMonsterInfo& pkt) {};
		virtual void Handle(const Pkt_CMovement& pkt) {};
		virtual void Handle(const Pkt_CChat& pkt) {};
	};

	//////////////////////////////////////////////////////////////////////////
	// ParseClientPacket
	//////////////////////////////////////////////////////////////////////////
	void ParseClientPacket(ClientPacketHandler& handler, const char* buffer, int& offset, int bufferLen)
	{
		int leftBufferLen = bufferLen;
		while(leftBufferLen > PacketHeaderSize)
		{
			PacketLenType packetLen = GetPacketLength(buffer, offset, bufferLen);
			if (leftBufferLen < (signed)packetLen)
				break;
			leftBufferLen -= packetLen;
			PacketType packetType = GetPacketType(buffer, offset, bufferLen);
			switch(packetType)
			{
			case eCP_CLogin:
				{
					Pkt_CLogin pkt;
					DeserializeT(pkt, buffer, offset, bufferLen);
					handler.Handle(pkt);
				}
				break;
			case eCP_CMyPlayerInfo:
				{
					Pkt_CMyPlayerInfo pkt;
					DeserializeT(pkt, buffer, offset, bufferLen);
					handler.Handle(pkt);
				}
				break;
			case eCP_COtherPlayerInfo:
				{
					Pkt_COtherPlayerInfo pkt;
					DeserializeT(pkt, buffer, offset, bufferLen);
					handler.Handle(pkt);
				}
				break;
			case eCP_CMonsterInfo:
				{
					Pkt_CMonsterInfo pkt;
					DeserializeT(pkt, buffer, offset, bufferLen);
					handler.Handle(pkt);
				}
				break;
			case eCP_CMovement:
				{
					Pkt_CMovement pkt;
					DeserializeT(pkt, buffer, offset, bufferLen);
					handler.Handle(pkt);
				}
				break;
			case eCP_CChat:
				{
					Pkt_CChat pkt;
					DeserializeT(pkt, buffer, offset, bufferLen);
					handler.Handle(pkt);
				}
				break;
			}
		}
	}

} //namespace Packet

#endif // __clientpacket_h__
