import json
import sys

def WriteSeperator(f, name):
	f.write('\t//////////////////////////////////////////////////////////////////////////\n')
	f.write('\t// %s\n'%(name))
	f.write('\t//////////////////////////////////////////////////////////////////////////\n')

def WriteSizeFunction(f, struct_name, members_node, consider_header):
	f.write('\ttemplate<> inline uint32 SizeT(const %s& data)\n'%(struct_name))
	f.write('\t{\n')
	f.write('\t\treturn ')
	if consider_header:
		f.write('PacketHeaderSize+')
	for member in members_node:
		is_vector = member.has_key('vector') and member['vector']
		if is_vector:
			f.write('SizeVectorT(data.%s)+'%(member['name']))
		else:
			f.write('SizeT(data.%s)+'%(member['name']))
	f.seek(f.tell()-1)
	f.write(';\n')
	f.write('\t}\n\n')
	f.write('\ttemplate<> inline uint32 SizeT(%s& data)\n'%(struct_name))
	f.write('\t{\n')
	f.write('\t\treturn SizeT((const %s&)data);\n'%(struct_name))
	f.write('\t}\n\n')

def WriteSerializeFunction(f, struct_name, members_node, consider_header, packet_type):
	f.write('\ttemplate<> inline bool SerializeT(')
	f.write('const %s& src, char* buffer, int& offset, int bufferLen)\n'%(struct_name))
	f.write('\t{\n')
	if consider_header:
		f.write('\t\tWriteHeader(%s, SizeT(src), buffer, offset, bufferLen);\n'%(packet_type))
	for member in members_node:
		is_vector = member.has_key('vector') and member['vector']
		if is_vector:
			f.write('\t\tSerializeVectorT(src.%s, buffer, offset, bufferLen);\n'%(member['name']))
		else :
			f.write('\t\tSerializeT(src.%s, buffer, offset, bufferLen);\n'%(member['name']))
	f.write('\t\treturn true;\n')
	f.write('\t}\n\n')
	
def WriteDeserializeFunction(f, struct_name, members_node, consider_header):
	f.write('\ttemplate<> inline bool DeserializeT(')
	f.write('%s& dst, const char* buffer, int& offset, int bufferLen)\n'%(struct_name))
	f.write('\t{\n')
	if consider_header:
		f.write('\t\tSkipHeader(buffer, offset, bufferLen);\n')
	for member in members_node:
		is_vector = member.has_key('vector') and member['vector']
		if  is_vector:
			f.write('\t\tDeserializeVectorT(dst.%s, buffer, offset, bufferLen);\n'%(member['name']))
		else:
			f.write('\t\tDeserializeT(dst.%s, buffer, offset, bufferLen);\n'%(member['name']))
	f.write('\t\treturn true;\n')
	f.write('\t}\n\n')
	
# read json
json_filename = sys.argv[1]
fr = open(json_filename, 'r')
root = json.load(fr)
fr.close()

# read config
write_filename = root["Config"]['Filename']
group_name = root["Config"]['Groupname']
enum_prefix = root["Config"]['EnumPrefix']
class_prefix = root["Config"]['ClassPrefix']

f = open(write_filename, 'w')
packet_array = root['Packets']
struct_array = []
if root.has_key('Structs'):
	struct_array = root['Structs']

f.write('// Automatically generated by PacketGenerator\n')
define_name = write_filename.split('.')[0].lower()
f.write('#ifndef __%s_h__\n'%(define_name))
f.write('#define __%s_h__\n'%(define_name))
f.write('\n')
f.write('#pragma once\n')
f.write('\n')

#include 
f.write('#include "../ClientServerCommon.h"\n')
f.write('#include "PacketCommon.h"\n\n')
f.write('namespace Packet\n{\n')
# enum
f.write('\tenum %sType\n'%(group_name))
f.write('\t{\n')
for packet_node in packet_array:
	name = enum_prefix+packet_node['name']
	f.write('\t\t%s,\n'%(name))
f.write('\t\t%sMax,\n'%(enum_prefix))
f.write('\t};\n\n')

# additional struct define
for struct_node in struct_array:
	f.write('\tstruct %s\n'%(struct_node['name']))
	f.write('\t{\n')
	for member in struct_node['members']:
		f.write('\t\t%s %s;\n'%(member['type'], member['name']))
	f.write('\n')
	f.write('\t\t%s& operator = (const %s& other)\n'%(struct_node['name'], struct_node['name']))
	f.write('\t\t{\n')
	f.write('\t\t\tif (this != &other)\n')
	f.write('\t\t\t{\n')
	for member in struct_node['members']:
		f.write('\t\t\t\t%s = other.%s;\n'%(member['name'], member['name']))
	f.write('\t\t\t}\n')
	f.write('\t\t\treturn *this;\n')
	f.write('\t\t}\n')
	f.write('\t};\n\n')

# packet struct define
for packet_node in packet_array:
	f.write('\tstruct %s%s\n'%(class_prefix,packet_node['name']))
	f.write('\t{\n')
	for member in packet_node['members']:
		f.write('\t\t%s %s;\n'%(member['type'], member['name']))
	f.write('\t};\n\n')
	
# additional struct size, serialize and deserialize
for struct_node in struct_array:
	struct_name = struct_node['name']
	WriteSeperator(f, struct_name)
	WriteSizeFunction(f, struct_name, struct_node['members'], False)
	WriteSerializeFunction(f, struct_name, struct_node['members'], False, '')
	WriteDeserializeFunction(f, struct_name, struct_node['members'], False)

# size, serialize and deserialize
for packet_node in packet_array:
	struct_name = class_prefix+packet_node['name']
	WriteSeperator(f, struct_name)
	WriteSizeFunction(f, struct_name, packet_node['members'], True)
	WriteSerializeFunction(f, struct_name, packet_node['members'], True, enum_prefix+packet_node['name'])
	WriteDeserializeFunction(f, struct_name, packet_node['members'], True)
	
# PacketHandler
packet_handlername = '%sHandler'%(group_name)
WriteSeperator(f, packet_handlername)
f.write('\tclass %s\n'%(packet_handlername))
f.write('\t{\n')
f.write('\tpublic:\n')
f.write('\t\t%s() {}\n'%(packet_handlername))
f.write('\t\tvirtual ~%s() {}\n\n'%(packet_handlername))
for packet_node in packet_array:
	f.write('\t\tvirtual void Handle(const %s%s& pkt) {};\n'%(class_prefix,packet_node['name']))
f.write('\t};\n\n')

# ParsePacket
WriteSeperator(f, 'Parse%s'%(group_name))
f.write('\tvoid Parse%s(%s& handler, '%(group_name, packet_handlername))
f.write('const char* buffer, int& offset, int bufferLen)\n')
f.write('\t{\n')
f.write('\t\tint leftBufferLen = bufferLen;\n')
f.write('\t\twhile(leftBufferLen > PacketHeaderSize)\n')
f.write('\t\t{\n')
f.write('\t\t\tPacketLenType packetLen = GetPacketLength(buffer, offset, bufferLen);\n')
f.write('\t\t\tif (leftBufferLen < (signed)packetLen)\n')
f.write('\t\t\t\tbreak;\n')
f.write('\t\t\tleftBufferLen -= packetLen;\n')
f.write('\t\t\tPacketType packetType = GetPacketType(buffer, offset, bufferLen);\n')
f.write('\t\t\tswitch(packetType)\n')
f.write('\t\t\t{\n')
for packet_node in packet_array:
	f.write('\t\t\tcase %s%s:\n'%(enum_prefix,packet_node['name']))
	f.write('\t\t\t\t{\n')
	f.write('\t\t\t\t\t%s%s pkt;\n'%(class_prefix,packet_node['name']))
	f.write('\t\t\t\t\tDeserializeT(pkt, buffer, offset, bufferLen);\n')
	f.write('\t\t\t\t\thandler.Handle(pkt);\n')
	f.write('\t\t\t\t}\n')
	f.write('\t\t\t\tbreak;\n')
f.write('\t\t\t}\n')
f.write('\t\t}\n')
f.write('\t}\n\n')

# close namespace and endif
f.write('} //namespace Packet\n\n')
f.write('#endif // __%s_h__\n'%(define_name))
f.close()