#include "StdAfx.h"
#include "ServerPacket.h"

namespace Packet
{

void ParseServerPacket(ServerPacketHandler& handler, const char* buffer, int& offset, int bufferLen)
{
	int leftBufferLen = bufferLen;
	while(leftBufferLen > PacketHeaderSize)
	{
		PacketLenType packetLen = GetPacketLength(buffer, offset, bufferLen);
		if (leftBufferLen < (signed)packetLen)
			break;
		leftBufferLen -= packetLen;
		PacketType packetType = GetPacketType(buffer, offset, bufferLen);
		switch(packetType)
		{
		case eSP_SLogin:
			{
				Pkt_SLogin pkt;
				DeserializeT(pkt, buffer, offset, bufferLen);
				handler.Handle(pkt);
			}
			break;
		case eSP_SMyPlayerInfo:
			{
				Pkt_SMyPlayerInfo pkt;
				DeserializeT(pkt, buffer, offset, bufferLen);
				handler.Handle(pkt);
			}
			break;
		case eSP_SOtherPlayerInfo:
			{
				Pkt_SOtherPlayerInfo pkt;
				DeserializeT(pkt, buffer, offset, bufferLen);
				handler.Handle(pkt);
			}
			break;
		case eSP_SMonsterInfo:
			{
				Pkt_SMonsterInfo pkt;
				DeserializeT(pkt, buffer, offset, bufferLen);
				handler.Handle(pkt);
			}
			break;
		case eSP_SMovement:
			{
				Pkt_SMovement pkt;
				DeserializeT(pkt, buffer, offset, bufferLen);
				handler.Handle(pkt);
			}
			break;
		case eSP_SChat:
			{
				Pkt_SChat pkt;
				DeserializeT(pkt, buffer, offset, bufferLen);
				handler.Handle(pkt);
			}
			break;
		}
	}
}

} // namespace Packet