// Automatically generated by PacketGenerator
#ifndef __serverpacket_h__
#define __serverpacket_h__

#pragma once

#include "../ClientServerCommon.h"
#include "PacketCommon.h"

namespace Packet
{
	enum ServerPacketType
	{
		eSP_SLogin,
		eSP_SMyPlayerInfo,
		eSP_SOtherPlayerInfo,
		eSP_SMonsterInfo,
		eSP_SMovement,
		eSP_SChat,
		eSP_Max,
	};

	struct PlayerInfo
	{
		int serial;
		SPosition pos;
		string name;
		string className;
		int level;

		PlayerInfo& operator = (const PlayerInfo& other)
		{
			if (this != &other)
			{
				serial = other.serial;
				pos = other.pos;
				name = other.name;
				className = other.className;
				level = other.level;
			}
			return *this;
		}
	};

	struct Pkt_SLogin
	{
		bool succeed;
		int serial;
	};

	struct Pkt_SMyPlayerInfo
	{
		PlayerInfo myInfo;
	};

	struct Pkt_SOtherPlayerInfo
	{
		std::vector<PlayerInfo> list;
	};

	struct Pkt_SMonsterInfo
	{
		std::vector<PlayerInfo> list;
	};

	struct Pkt_SMovement
	{
		int serial;
		SPosition src;
		SPosition dst;
	};

	struct Pkt_SChat
	{
		int serial;
		string message;
	};

	//////////////////////////////////////////////////////////////////////////
	// PlayerInfo
	//////////////////////////////////////////////////////////////////////////
	template<> inline uint32 SizeT(const PlayerInfo& data)
	{
		return SizeT(data.serial)+SizeT(data.pos)+SizeT(data.name)+SizeT(data.className)+SizeT(data.level);
	}

	template<> inline uint32 SizeT(PlayerInfo& data)
	{
		return SizeT((const PlayerInfo&)data);
	}

	template<> inline bool SerializeT(const PlayerInfo& src, char* buffer, int& offset, int bufferLen)
	{
		SerializeT(src.serial, buffer, offset, bufferLen);
		SerializeT(src.pos, buffer, offset, bufferLen);
		SerializeT(src.name, buffer, offset, bufferLen);
		SerializeT(src.className, buffer, offset, bufferLen);
		SerializeT(src.level, buffer, offset, bufferLen);
		return true;
	}

	template<> inline bool DeserializeT(PlayerInfo& dst, const char* buffer, int& offset, int bufferLen)
	{
		DeserializeT(dst.serial, buffer, offset, bufferLen);
		DeserializeT(dst.pos, buffer, offset, bufferLen);
		DeserializeT(dst.name, buffer, offset, bufferLen);
		DeserializeT(dst.className, buffer, offset, bufferLen);
		DeserializeT(dst.level, buffer, offset, bufferLen);
		return true;
	}

	//////////////////////////////////////////////////////////////////////////
	// Pkt_SLogin
	//////////////////////////////////////////////////////////////////////////
	template<> inline uint32 SizeT(const Pkt_SLogin& data)
	{
		return PacketHeaderSize+SizeT(data.succeed)+SizeT(data.serial);
	}

	template<> inline uint32 SizeT(Pkt_SLogin& data)
	{
		return SizeT((const Pkt_SLogin&)data);
	}

	template<> inline bool SerializeT(const Pkt_SLogin& src, char* buffer, int& offset, int bufferLen)
	{
		WriteHeader(eSP_SLogin, SizeT(src), buffer, offset, bufferLen);
		SerializeT(src.succeed, buffer, offset, bufferLen);
		SerializeT(src.serial, buffer, offset, bufferLen);
		return true;
	}

	template<> inline bool DeserializeT(Pkt_SLogin& dst, const char* buffer, int& offset, int bufferLen)
	{
		SkipHeader(buffer, offset, bufferLen);
		DeserializeT(dst.succeed, buffer, offset, bufferLen);
		DeserializeT(dst.serial, buffer, offset, bufferLen);
		return true;
	}

	//////////////////////////////////////////////////////////////////////////
	// Pkt_SMyPlayerInfo
	//////////////////////////////////////////////////////////////////////////
	template<> inline uint32 SizeT(const Pkt_SMyPlayerInfo& data)
	{
		return PacketHeaderSize+SizeT(data.myInfo);
	}

	template<> inline uint32 SizeT(Pkt_SMyPlayerInfo& data)
	{
		return SizeT((const Pkt_SMyPlayerInfo&)data);
	}

	template<> inline bool SerializeT(const Pkt_SMyPlayerInfo& src, char* buffer, int& offset, int bufferLen)
	{
		WriteHeader(eSP_SMyPlayerInfo, SizeT(src), buffer, offset, bufferLen);
		SerializeT(src.myInfo, buffer, offset, bufferLen);
		return true;
	}

	template<> inline bool DeserializeT(Pkt_SMyPlayerInfo& dst, const char* buffer, int& offset, int bufferLen)
	{
		SkipHeader(buffer, offset, bufferLen);
		DeserializeT(dst.myInfo, buffer, offset, bufferLen);
		return true;
	}

	//////////////////////////////////////////////////////////////////////////
	// Pkt_SOtherPlayerInfo
	//////////////////////////////////////////////////////////////////////////
	template<> inline uint32 SizeT(const Pkt_SOtherPlayerInfo& data)
	{
		return PacketHeaderSize+SizeVectorT(data.list);
	}

	template<> inline uint32 SizeT(Pkt_SOtherPlayerInfo& data)
	{
		return SizeT((const Pkt_SOtherPlayerInfo&)data);
	}

	template<> inline bool SerializeT(const Pkt_SOtherPlayerInfo& src, char* buffer, int& offset, int bufferLen)
	{
		WriteHeader(eSP_SOtherPlayerInfo, SizeT(src), buffer, offset, bufferLen);
		SerializeVectorT(src.list, buffer, offset, bufferLen);
		return true;
	}

	template<> inline bool DeserializeT(Pkt_SOtherPlayerInfo& dst, const char* buffer, int& offset, int bufferLen)
	{
		SkipHeader(buffer, offset, bufferLen);
		DeserializeVectorT(dst.list, buffer, offset, bufferLen);
		return true;
	}

	//////////////////////////////////////////////////////////////////////////
	// Pkt_SMonsterInfo
	//////////////////////////////////////////////////////////////////////////
	template<> inline uint32 SizeT(const Pkt_SMonsterInfo& data)
	{
		return PacketHeaderSize+SizeVectorT(data.list);
	}

	template<> inline uint32 SizeT(Pkt_SMonsterInfo& data)
	{
		return SizeT((const Pkt_SMonsterInfo&)data);
	}

	template<> inline bool SerializeT(const Pkt_SMonsterInfo& src, char* buffer, int& offset, int bufferLen)
	{
		WriteHeader(eSP_SMonsterInfo, SizeT(src), buffer, offset, bufferLen);
		SerializeVectorT(src.list, buffer, offset, bufferLen);
		return true;
	}

	template<> inline bool DeserializeT(Pkt_SMonsterInfo& dst, const char* buffer, int& offset, int bufferLen)
	{
		SkipHeader(buffer, offset, bufferLen);
		DeserializeVectorT(dst.list, buffer, offset, bufferLen);
		return true;
	}

	//////////////////////////////////////////////////////////////////////////
	// Pkt_SMovement
	//////////////////////////////////////////////////////////////////////////
	template<> inline uint32 SizeT(const Pkt_SMovement& data)
	{
		return PacketHeaderSize+SizeT(data.serial)+SizeT(data.src)+SizeT(data.dst);
	}

	template<> inline uint32 SizeT(Pkt_SMovement& data)
	{
		return SizeT((const Pkt_SMovement&)data);
	}

	template<> inline bool SerializeT(const Pkt_SMovement& src, char* buffer, int& offset, int bufferLen)
	{
		WriteHeader(eSP_SMovement, SizeT(src), buffer, offset, bufferLen);
		SerializeT(src.serial, buffer, offset, bufferLen);
		SerializeT(src.src, buffer, offset, bufferLen);
		SerializeT(src.dst, buffer, offset, bufferLen);
		return true;
	}

	template<> inline bool DeserializeT(Pkt_SMovement& dst, const char* buffer, int& offset, int bufferLen)
	{
		SkipHeader(buffer, offset, bufferLen);
		DeserializeT(dst.serial, buffer, offset, bufferLen);
		DeserializeT(dst.src, buffer, offset, bufferLen);
		DeserializeT(dst.dst, buffer, offset, bufferLen);
		return true;
	}

	//////////////////////////////////////////////////////////////////////////
	// Pkt_SChat
	//////////////////////////////////////////////////////////////////////////
	template<> inline uint32 SizeT(const Pkt_SChat& data)
	{
		return PacketHeaderSize+SizeT(data.serial)+SizeT(data.message);
	}

	template<> inline uint32 SizeT(Pkt_SChat& data)
	{
		return SizeT((const Pkt_SChat&)data);
	}

	template<> inline bool SerializeT(const Pkt_SChat& src, char* buffer, int& offset, int bufferLen)
	{
		WriteHeader(eSP_SChat, SizeT(src), buffer, offset, bufferLen);
		SerializeT(src.serial, buffer, offset, bufferLen);
		SerializeT(src.message, buffer, offset, bufferLen);
		return true;
	}

	template<> inline bool DeserializeT(Pkt_SChat& dst, const char* buffer, int& offset, int bufferLen)
	{
		SkipHeader(buffer, offset, bufferLen);
		DeserializeT(dst.serial, buffer, offset, bufferLen);
		DeserializeT(dst.message, buffer, offset, bufferLen);
		return true;
	}

	//////////////////////////////////////////////////////////////////////////
	// ServerPacketHandler
	//////////////////////////////////////////////////////////////////////////
	class ServerPacketHandler
	{
	public:
		ServerPacketHandler() {}
		virtual ~ServerPacketHandler() {}

		virtual void Handle(const Pkt_SLogin& pkt) {};
		virtual void Handle(const Pkt_SMyPlayerInfo& pkt) {};
		virtual void Handle(const Pkt_SOtherPlayerInfo& pkt) {};
		virtual void Handle(const Pkt_SMonsterInfo& pkt) {};
		virtual void Handle(const Pkt_SMovement& pkt) {};
		virtual void Handle(const Pkt_SChat& pkt) {};
	};

	//////////////////////////////////////////////////////////////////////////
	// ParseServerPacket
	//////////////////////////////////////////////////////////////////////////
	void ParseServerPacket(ServerPacketHandler& handler, const char* buffer, int& offset, int bufferLen);

} //namespace Packet

#endif // __serverpacket_h__
