// Automatic generate by PacketGenerator.
#ifndef __testpacket_h__
#define __testpacket_h__

#pragma once

#include "PacketCommon.h"

namespace Packet
{
	typedef enum
	{
		LoginRequest,
		LoginResponse,
		Chat,
		PlayerListRequest,
		PlayerListResponse,
		MaxPacket,
	};

	struct SLoginRequest
	{
		string username;
		string password;
	};

	struct SLoginResponse
	{
		bool succeed;
		uint32 sessionId;
		uint32 level;
	};

	struct SChat
	{
		string message;
		uint8 chatType;
	};

	struct SPlayerListRequest
	{
		int serial;
	};

	struct PlayerInfoOld
	{
		int serial;
		string name;
		int level;
	};

	struct SPlayerListResponse
	{
		std::vector<PlayerInfoOld> playerList;		
	};

	//////////////////////////////////////////////////////////////////////////
	// SLoginRequest
	//////////////////////////////////////////////////////////////////////////

	template<> inline uint32 SizeT(const SLoginRequest& data)
	{
		return PacketHeaderSize+SizeT(data.username)+SizeT(data.password);
	}

	template<> inline uint32 SizeT(SLoginRequest& data)
	{
		return SizeT((const SLoginRequest&)data);
	}

	template<> inline bool SerializeT(const SLoginRequest& src, char* buffer, int& offset, int len)
	{
		WriteHeader(LoginRequest, SizeT(src), buffer, offset, len);
		SerializeT(src.username, buffer, offset, len);
		SerializeT(src.password, buffer, offset, len);
		return true;
	}

	template<> inline bool DeserializeT(SLoginRequest& dst, const char* buffer, int& offset, int len)
	{
		SkipHeader(buffer, offset, len);
		DeserializeT(dst.username, buffer, offset, len);
		DeserializeT(dst.password, buffer, offset, len);
		return true;
	}

	//////////////////////////////////////////////////////////////////////////
	// SLoginResult
	//////////////////////////////////////////////////////////////////////////
	template<> inline uint32 SizeT(const SLoginResponse& data)
	{
		return PacketHeaderSize+SizeT(data.succeed)+SizeT(data.sessionId)+SizeT(data.level);
	}
	template<> inline uint32 SizeT(SLoginResponse& data)
	{
		return SizeT((const SLoginResponse&)data);
	}

	template<> inline bool SerializeT(const SLoginResponse& src, char* buffer, int& offset, int len)
	{
		WriteHeader(LoginResponse, SizeT(src), buffer, offset, len);
		SerializeT(src.succeed, buffer, offset, len);
		SerializeT(src.sessionId, buffer, offset, len);
		SerializeT(src.level, buffer, offset, len);
		return true;
	}

	template<> inline bool DeserializeT(SLoginResponse& dst, const char* buffer, int& offset, int len)
	{
		SkipHeader(buffer, offset, len);
		DeserializeT(dst.succeed, buffer, offset, len);
		DeserializeT(dst.sessionId, buffer, offset, len);
		DeserializeT(dst.level, buffer, offset, len);
		return true;
	}


	//////////////////////////////////////////////////////////////////////////
	// SChat
	//////////////////////////////////////////////////////////////////////////
	template<> inline uint32 SizeT(const SChat& data)
	{
		return PacketHeaderSize+SizeT(data.message)+SizeT(data.chatType);
	}
	template<> inline uint32 SizeT(SChat& data)
	{
		return SizeT((const SChat&)data);
	}

	template<> inline bool SerializeT(const SChat& src, char* buffer, int& offset, int len)
	{
		WriteHeader(Chat, SizeT(src), buffer, offset, len);
		SerializeT(src.message, buffer, offset, len);
		SerializeT(src.chatType, buffer, offset, len);
		return true;
	}

	template<> inline bool DeserializeT(SChat& dst, const char* buffer, int& offset, int len)
	{
		SkipHeader(buffer, offset, len);
		DeserializeT(dst.message, buffer, offset, len);
		DeserializeT(dst.chatType, buffer, offset, len);
		return true;
	}

	//////////////////////////////////////////////////////////////////////////
	// SPlayerListRequest
	//////////////////////////////////////////////////////////////////////////
	template<> inline uint32 SizeT(const SPlayerListRequest& data)
	{
		return PacketHeaderSize+SizeT(data.serial);
	}
	template<> inline uint32 SizeT(SPlayerListRequest& data)
	{
		return SizeT((const SPlayerListRequest&)data);
	}

	template<> inline bool SerializeT(const SPlayerListRequest& src, char* buffer, int& offset, int len)
	{
		WriteHeader(PlayerListRequest, SizeT(src), buffer, offset, len);
		SerializeT(src.serial, buffer, offset, len);
		return true;
	}

	template<> inline bool DeserializeT(SPlayerListRequest& dst, const char* buffer, int& offset, int len)
	{
		SkipHeader(buffer, offset, len);
		DeserializeT(dst.serial, buffer, offset, len);
		return true;
	}

	//////////////////////////////////////////////////////////////////////////
	// SPlayerListResponse
	//////////////////////////////////////////////////////////////////////////
	template<> inline uint32 SizeT(const SPlayerListResponse& data)
	{
		return SizeVectorT(data.playerList);
	}
	template<> inline uint32 SizeT(SPlayerListResponse& data)
	{
		return SizeT((const SPlayerListResponse&)data);
	}

	template<> inline uint32 SizeT(const PlayerInfoOld& data)
	{
		return SizeT(data.serial) + SizeT(data.name) + SizeT(data.level);
	}
	template<> inline uint32 SizeT(PlayerInfoOld& data)
	{
		return SizeT((const PlayerInfoOld&)data);
	}

	template<> inline bool SerializeT<PlayerInfoOld>(const PlayerInfoOld& data, char* buffer, int& offset, int bufferLen)
	{
		SerializeT(data.serial, buffer, offset, bufferLen);
		SerializeT(data.name, buffer, offset, bufferLen);
		SerializeT(data.level, buffer, offset, bufferLen);
		return true;
	}

	template<> inline bool DeserializeT<PlayerInfoOld>(PlayerInfoOld& data, const char* buffer, int& offset, int bufferLen)
	{
		DeserializeT(data.serial, buffer, offset, bufferLen);
		DeserializeT(data.name, buffer, offset, bufferLen);
		DeserializeT(data.level, buffer, offset, bufferLen);
		return true;
	}

	template<> inline bool SerializeT(const SPlayerListResponse& src, char* buffer, int& offset, int len)
	{
		WriteHeader(PlayerListResponse, SizeT(src), buffer, offset, len);
		SerializeVectorT(src.playerList, buffer, offset, len);
		return true;
	}

	template<> inline bool DeserializeT(SPlayerListResponse& dst, const char* buffer, int& offset, int len)
	{
		SkipHeader(buffer, offset, len);
		DeserializeVectorT(dst.playerList, buffer, offset, len);
		return true;
	}

	//////////////////////////////////////////////////////////////////////////

	class TestPacketHandler
	{
	public:
		TestPacketHandler() {}
		virtual ~TestPacketHandler() {}

		virtual void Handle(const SLoginRequest& pkt){};
		virtual void Handle(const SLoginResponse& pkt){};
		virtual void Handle(const SChat& pkt){};
		virtual void Handle(const SPlayerListRequest& pkt){};
		virtual void Handle(const SPlayerListResponse& pkt){};
	};

	//////////////////////////////////////////////////////////////////////////

	void ParsePacket(TestPacketHandler& handler, const char* buffer, int& offset, int len)
	{
		int leftBufferLen = len;
		while(leftBufferLen > PacketHeaderSize)
		{
			PacketLenType packetLen = GetPacketLength(buffer, offset, len);
			if (leftBufferLen < (signed)packetLen)
				break;
			leftBufferLen -= packetLen;
			PacketType packetType = GetPacketType(buffer, offset, len);
			switch(packetType)
			{
			case LoginRequest:
				{
					SLoginRequest pkt;
					DeserializeT(pkt, buffer, offset, len);
					handler.Handle(pkt);
				}
				break;
			case LoginResponse:
				{
					SLoginResponse pkt;
					DeserializeT(pkt, buffer, offset, len);
					handler.Handle(pkt);
				}
				break;
			case Chat:
				{
					SChat pkt;
					DeserializeT(pkt, buffer, offset, len);
					handler.Handle(pkt);
				}
				break;
			case PlayerListRequest:
				{
					SPlayerListRequest pkt;
					DeserializeT(pkt, buffer, offset, len);
					handler.Handle(pkt);
				}
				break;
			case PlayerListResponse:
				{
					SPlayerListResponse pkt;
					DeserializeT(pkt, buffer, offset, len);
					handler.Handle(pkt);
				}
				break;
			}
		}
	}

} // namespace Packet


#endif // __testpacket_h__