#include "StdAfx.h"
#include "ActorSystem.h"

#include <ICryAnimation.h>
#include <IGameFramework.h>


CActor::CActor(IEntity* entity)
: m_pEntity(entity)
{
	Reset();
}

CActor::~CActor()
{
}

void CActor::Reset()
{
	if (!m_pEntity)
		return;

	m_pEntity->SetProxy(ENTITY_PROXY_USER, this);

  if (IScriptTable* pScriptTable = m_pEntity->GetScriptTable())
	  Script::CallMethod(pScriptTable, "SetActorModel");

	Physicalize();

	// Temporary code for animation
	ICharacterInstance *pChar = m_pEntity->GetCharacter(0);
	if (!pChar)
		return;

	//QuatT pos = m_pEntity->GetPos() + Vec3(1.0f, 0.0, 0.0f);
	//pChar->SkeletonPreProcess();


	IAnimationSet* pAnimSet = pChar->GetIAnimationSet();
	if (!pAnimSet)
		return;

	unsigned int nAnimCount = pAnimSet->GetAnimationCount();
	ISkeletonAnim* pSkelAnim = pChar->GetISkeletonAnim();
	if (!pSkelAnim)
		return;

	CryCharAnimationParams animParams;
	animParams.m_nFlags = CA_LOOP_ANIMATION;
	animParams.m_fTransTime = 0.2f;

	const char* animName = pAnimSet->GetNameByAnimID(3);
	int nAnimFlag = pAnimSet->GetAnimationFlags(0);

	pSkelAnim->StopAnimationsAllLayers();
	pSkelAnim->StartAnimation(animName,animParams);

	m_pEntity->Activate(true);
}

void CActor::Physicalize()
{
	CRY_ASSERT(m_pEntity);
	if (!m_pEntity)
			return;

	pe_player_dimensions playerDim;
	pe_player_dynamics playerDyn;
	SEntityPhysicalizeParams pp;

	pp.pPlayerDimensions = &playerDim;
	pp.pPlayerDynamics = &playerDyn;

	pp.nSlot = 0;
	pp.type = PE_LIVING;
	pp.mass = 80.f;
	pp.density = 1.f;
	pp.nFlagsOR = 0;
	pp.nAttachToPart = 0;
	pp.fStiffnessScale = 1.f;
	
	m_pEntity->Physicalize(pp);
}

void CActor::Done()
{
	IActorSystem *pActorSystem = gEnv->pGame->GetIGameFramework()->GetIActorSystem();
	CRY_ASSERT(pActorSystem);
	if (!pActorSystem)
		return;

	pActorSystem->RemoveActor(m_pEntity->GetId());
}


// CActorSystem --------------------------------------------------------------
CActorSystem::CActorSystem()
{
	Init();
}

CActorSystem::~CActorSystem()
{
}

void CActorSystem::Init()
{
	RegisterActorClass();
}

bool CActorSystem::RegisterActorClass()
{
	IEntityClassRegistry::SEntityClassDesc simpleCharacterClass;
	simpleCharacterClass.sName = "MiniActor";
	simpleCharacterClass.sScriptFile = "Scripts/Entities/MiniActor/MiniActor.lua";
	if (!gEnv->pEntitySystem->GetClassRegistry()->RegisterStdClass(simpleCharacterClass))
	{
		CRY_ASSERT_MESSAGE(0, "Unable to register entity class");
		return false;
	}
	return true;
}

EntityId CActorSystem::CreateActor(const char* name, const Vec3& pos, const char* actorClass)
{
	// Spawns an entity for actor.
	IEntityClass *pEntityClass = gEnv->pEntitySystem->GetClassRegistry()->FindClass(actorClass);
	CRY_ASSERT(pEntityClass);
	if (!pEntityClass)
		return 0;

	SEntitySpawnParams params;
	params.sName = name;
	params.vPosition = pos;
	params.nFlags = ENTITY_FLAG_TRIGGER_AREAS;
	params.pClass = pEntityClass;
	IEntity *pEntity = gEnv->pEntitySystem->SpawnEntity(params, true);
	CRY_ASSERT(pEntity);
	if (!pEntity)
		return 0;

	CActor *pActor = new CActor(pEntity);
	CRY_ASSERT(pActor);
	if (!pActor)
		return 0;
	AddActor(pEntity->GetId(), pActor);

	return pEntity->GetId();
}

void CActorSystem::AddActor(EntityId entityId, IActor *pProxy)
{
	m_actors.insert(TActorMap::value_type(entityId, pProxy));
}

void CActorSystem::RemoveActor(EntityId entityId)
{
	stl::member_find_and_erase(m_actors, entityId);
}

IActor* CActorSystem::GetActor(EntityId entityId)
{
	TActorMap::iterator it = m_actors.find(entityId);
	if (it != m_actors.end())
	{
		return it->second;
	}
	return 0;
}
