#ifndef __ACTOR_SYSTEM_H__
#define __ACTOR_SYSTEM_H__

#if _MSC_VER > 1000
#	pragma once
#endif

#include <IActorSystem.h>

struct IEntity;

typedef std::map<EntityId, IActor *> TActorMap;

// Actor
class CActor : public IActor
{
public:
	CActor(IEntity* entity);
	VIRTUAL ~CActor();

	// IActor
	VIRTUAL IEntity*	GetEntity() { return m_pEntity; }
	// ~IActor

	// IEntityProxy
	VIRTUAL EEntityProxy GetType() { return ENTITY_PROXY_USER; }
	VIRTUAL bool Init( IEntity *pEntity,SEntitySpawnParams &params ) { return true; };
	VIRTUAL void Done();
	VIRTUAL void Release() { delete this; }
	VIRTUAL void Update( SEntityUpdateContext &ctx ) {}
	VIRTUAL void ProcessEvent( SEntityEvent &event ) {}
	VIRTUAL void SerializeXML( XmlNodeRef &entityNode,bool bLoading ) {}
	VIRTUAL void Serialize( TSerialize ser ) {}
	VIRTUAL bool NeedSerialize() { return true; }
	// ~IEntityProxy

	VIRTUAL	void			Reset();
	VIRTUAL void			Physicalize();

private:
	IEntity*					m_pEntity;

	DISALLOW_COPY_AND_ASSIGN(CActor);
};


// ActorSystem
class CActorSystem : public IActorSystem
{
public:
	CActorSystem();
	VIRTUAL ~CActorSystem();

	VIRTUAL void			Init();

	// IActorSystem
	VIRTUAL EntityId	CreateActor(const char* name, const Vec3& pos, const char* actorClass);
	VIRTUAL void			AddActor(EntityId entityId, IActor *pProxy);
	VIRTUAL void			RemoveActor(EntityId entityId);
	VIRTUAL IActor*		GetActor(EntityId entityId);
	// ~IActorSystem

protected:
	bool							RegisterActorClass();

private:
	TActorMap					m_actors;
};

#endif __ACTOR_SYSTEM_H__

