#include "StdAfx.h"
#include "CameraView.h"

CCameraView::CCameraView() :
	m_altitude(gf_PI/4.0f)
{
}

CCameraView::~CCameraView()
{
}

void CCameraView::IncrementAltitude(const float deltaRad)
{
	m_altitude += deltaRad;
	Limit(m_altitude, gf_PI/12.0f, gf_PI/2.0f);
}

void CCameraView::Update(const IEntity* targetEntity)
{
	CRY_SAFE_RETURN(!targetEntity, CRY_NO_RETURN_VALUE);

	CCamera cam = gEnv->pSystem->GetViewCamera();
	cam.SetAngles(Ang3(-m_altitude, 0.0f, targetEntity->GetRotation().GetRotZ()));

	const float kDistance = 6.0f;
	Vec3 backward = -targetEntity->GetForwardDir();
	Vec3 delta = backward * cosf(m_altitude) * kDistance;
	delta.z += sinf(m_altitude) * kDistance;
	cam.SetPosition(targetEntity->GetPos() + targetEntity->GetForwardDir()*(kDistance/3.0f) + delta);

	gEnv->pSystem->SetViewCamera(cam);
}