/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2004.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  
 -------------------------------------------------------------------------
  History:
	- 14:7:2010		10:00 : Adapted to GameClient by Dongwook Ha
  - 10:2:2010	14:00 : Rewritten by Christian Helmich
  - 30:8:2004   11:19 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "EditorGame.h"
#include "GameStartup.h"


#define EDITOR_SERVER_PORT 0xed17

//static member vars
ICVar* CEditorGame::s_pEditorGameMode = NULL;
CEditorGame* CEditorGame::s_pEditorGame = NULL;

// DLL interface
extern "C" 
{
	GAME_API IGameStartup* CreateGameStartup();
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
// CEditorGame ctor/dtor

CEditorGame::CEditorGame():
	m_pGame(0),
	m_pGameStartup(0),
	//m_pEquipmentSystemInterface(0),
	m_bEnabled(false),
	m_bGameMode(false),
	m_bPlayer(false)
{	
	s_pEditorGame = this;
	s_pEditorGameMode = NULL;
}


CEditorGame::~CEditorGame()
{	
	s_pEditorGame = NULL;
	SAFE_RELEASE(s_pEditorGameMode);
}


IEditorGame* CEditorGame::CreateInstance()
{
	return new CEditorGame();
}

// CEditorGame ctor/dtor/
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
// IEditorGame implementation

//- game instance lifecycle

bool CEditorGame::Init(ISystem* pSystem, IGameToEditorInterface* pGameToEditorInterface)
{
	CRY_ASSERT(pSystem);
	CRY_SAFE_RETURN(!pSystem, false);

	CRY_ASSERT(pGameToEditorInterface);
	CRY_SAFE_RETURN(!pGameToEditorInterface, false);
	
	//initialize GameStartup
	SSystemInitParams startupParams;
	startupParams.bEditor = true;
	startupParams.pSystem = pSystem;
	startupParams.bExecuteCommandLine = false;		// in editor we do it later - after other things are initialized

	m_pGameStartup = CreateGameStartup();
	CRY_ASSERT(m_pGameStartup);
	CRY_SAFE_RETURN(!m_pGameStartup, false);

	m_pGame = m_pGameStartup->Init(startupParams);
	CRY_ASSERT(m_pGame);
	CRY_SAFE_RETURN(!m_pGame, false);

	InitUIEnums(pGameToEditorInterface);
	
	gEnv->bClient = true;
	gEnv->bServer = true;
	gEnv->bMultiplayer = false;

	s_pEditorGameMode = REGISTER_INT( "net_gamemode", 0, 0, "Should editor connect a new client?");
	CRY_ASSERT(s_pEditorGameMode);
	CRY_SAFE_RETURN(!s_pEditorGameMode, false);
	s_pEditorGameMode->SetOnChangeCallback(&OnChangeEditorMode);

	SetGameMode(false);

	REGISTER_COMMAND( "net_reseteditorclient", ResetClient, 0, "Resets player and gamerules!" );

	ConfigureNetContext(true);

	return true;
}


int CEditorGame::Update(bool haveFocus, unsigned int updateFlags)
{
	CRY_ASSERT(m_pGameStartup);
	return m_pGameStartup->Update(haveFocus, updateFlags);
}


void CEditorGame::Shutdown()
{
	CRY_ASSERT(m_pGameStartup);
	gEnv->pConsole->RemoveCommand("net_reseteditorclient");

	EnablePlayer(false);
	SetGameMode(false);
	m_pGameStartup->Shutdown();
}

//- game instance lifecycle/
//////////////////////////////////////////////////////////////////////////
//- game mode

bool CEditorGame::SetGameMode(bool bGameMode)
{
	m_bGameMode = bGameMode;

	bool on = bGameMode;
	CRY_ASSERT(s_pEditorGameMode);
	CRY_SAFE_RETURN(!s_pEditorGameMode, false);
	if (s_pEditorGameMode->GetIVal() == 0)
		on = m_bPlayer;

	bool ok = ConfigureNetContext( on );
	if (ok)
	{
		if(gEnv->IsEditor())
		{
			m_pGame->EditorResetGame(bGameMode);
		}
	}
	else
	{
		GameWarning("Failed configuring net context");
	}
	return ok;
}

//- game mode/
//////////////////////////////////////////////////////////////////////////
//- player

IEntity* CEditorGame::GetPlayer()
{
	return NULL;
}


void CEditorGame::SetPlayerPosAng(Vec3 pos,Vec3 viewDir)
{
}


void CEditorGame::HidePlayer(bool bHide)
{
}

//- player/
//////////////////////////////////////////////////////////////////////////
//- level loading

void CEditorGame::OnBeforeLevelLoad()
{
}


void CEditorGame::OnAfterLevelLoad(const char* levelName, const char* levelFolder)
{
}

//- level loading/
//////////////////////////////////////////////////////////////////////////
//- game sub systems

IFlowSystem * CEditorGame::GetIFlowSystem()
{
	return NULL;
}


IGameTokenSystem* CEditorGame::GetIGameTokenSystem()
{
	return NULL;
}


IEquipmentSystemInterface* CEditorGame::GetIEquipmentSystemInterface()
{
	return NULL; //m_pEquipmentSystemInterface;
}

//- game sub systems/
// IEditorGame implementation/
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
// utility functions

void CEditorGame::InitUIEnums(IGameToEditorInterface* pGTE)
{
	CRY_ASSERT(pGTE);
	InitGlobalFileEnums(pGTE);
	InitActionEnums(pGTE);
}

//-----------------------------------

void CEditorGame::InitGlobalFileEnums(IGameToEditorInterface* pGTE)
{
	CRY_ASSERT(pGTE);
	CRY_SAFE_RETURN(!pGTE, CRY_NO_RETURN_VALUE);
	// Read in enums stored offline XML. Format is
	// <GlobalEnums>
	//   <EnumName>
	//     <entry enum="someName=someValue" />  <!-- displayed name != value -->
	// 	   <entry enum="someNameValue" />       <!-- displayed name == value -->
	//   </EnumName>
	// </GlobalEnums>
	//
	XmlNodeRef rootNode = GetISystem()->LoadXmlFile("Libs/UI/GlobalEnums.xml");
	if (!rootNode || !rootNode->getTag() || stricmp(rootNode->getTag(), "GlobalEnums") != 0)
	{
		// GameWarning("CEditorGame::InitUIEnums: File 'Libs/UI/GlobalEnums.xml' is not a GlobalEnums file");
		return;
	}
	for (int i = 0; i < rootNode->getChildCount(); ++i)
	{
		XmlNodeRef enumNameNode = rootNode->getChild(i);
		const char* enumId = enumNameNode->getTag();
		if (enumId == 0 || *enumId=='\0')
			continue;
		int maxChilds = enumNameNode->getChildCount();
		if (maxChilds > 0)
		{
			// allocate enough space to hold all strings
			const char** nameValueStrings = new const char*[maxChilds];
			int curEntryIndex = 0;
			for (int j = 0; j < maxChilds; ++j)
			{
				XmlNodeRef enumNode = enumNameNode->getChild(j);
				const char* nameValue = enumNode->getAttr("enum");
				if (nameValue != 0 && *nameValue!='\0')
				{
					// put in the nameValue pair
					nameValueStrings[curEntryIndex++] = nameValue;
				}
			}
			// if we found some entries inform CUIDataBase about it
			if (curEntryIndex > 0)
				pGTE->SetUIEnums(enumId, nameValueStrings, curEntryIndex);

			// be nice and free our array
			delete[] nameValueStrings;
		}
	}
}

//-----------------------------------

void CEditorGame::InitActionEnums(IGameToEditorInterface* pGTE)
{
}

//-----------------------------------

bool CEditorGame::ConfigureNetContext( bool on )
{
	return true;
}

//-----------------------------------

void CEditorGame::OnChangeEditorMode(ICVar* pVar)
{
	CRY_ASSERT(pVar);
	CRY_ASSERT(s_pEditorGameMode);
	CRY_ASSERT(pVar == s_pEditorGameMode);
	if (s_pEditorGame)
	{
		s_pEditorGame->SetGameMode( s_pEditorGame->m_bGameMode );
	}
}

//-----------------------------------

void CEditorGame::EnablePlayer(bool bPlayer)
{
}

//-----------------------------------

void CEditorGame::ResetClient(IConsoleCmdArgs*)
{
}

// utility functions/
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#include UNIQUE_VIRTUAL_WRAPPER(IEditorGame)

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////