#include <StdAfx.h>
#include "Game.h"

#include <IActorSystem.h>
#include <IGameFramework.h>
#include <ILevelSystem.h>

#include "CameraView.h"
#include "InputHandler.h"
#include "PlayerManager.h"
#include "TestConnection.h"

CGame* g_pGame = NULL;	// very obviously bad coding practice.

CGame::CGame() :
	m_pFramework(0),
	m_pConsole(0),
	m_localActorId(0),
	m_isConnectedToServer(false)
{
	CRY_ASSERT(NULL == g_pGame);
	g_pGame = this;

	GetISystem()->SetIGame(this);
}

CGame::~CGame()
{
	g_pGame = 0;
}

IGame* CGame::CreateInstance(IGameFramework* pGameFramework)
{
	CRY_ASSERT(pGameFramework);
	CRY_SAFE_RETURN(!pGameFramework, NULL);

	ModuleInitISystem(pGameFramework->GetISystem(), "CryGame");

	static char pGameBuffer[sizeof(CGame)];
	return new ((void*)pGameBuffer) CGame();
}

bool CGame::Init(IGameFramework *pFramework)
{
	LOADING_TIME_PROFILE_SECTION(GetISystem());

	CRY_ASSERT(gEnv);
	CRY_SAFE_RETURN(!gEnv, false);

	// Initializes gameplay foundation framework
	CRY_ASSERT(pFramework);
	CRY_SAFE_RETURN(!pFramework, false);
	m_pFramework = pFramework;	

	// Initialize game modules
	m_pCameraView.reset(new CCameraView);
	CRY_SAFE_RETURN(!m_pCameraView.get(), false);
	m_pPlayerManager.reset(new CPlayerManager);
	CRY_SAFE_RETURN(!m_pPlayerManager.get(), false);
	m_pInputHandler.reset(new CInputHandler);
	CRY_SAFE_RETURN(!m_pInputHandler.get(), false);
	m_pServerConnection.reset(new CTestConnection);
	CRY_SAFE_RETURN(!m_pServerConnection.get(), false);

	// Initializes command line
	CRY_ASSERT(gEnv->pConsole);
	CRY_SAFE_RETURN(!gEnv->pConsole, false);
	m_pConsole = gEnv->pConsole;
	m_pConsole->CreateKeyBind("f12", "r_getscreenshot 2");

	return true;
}

bool CGame::CompleteInit()
{
	// Loads the specified level.
	ILevelSystem* pLevelSystem = m_pFramework->GetILevelSystem();
	pLevelSystem->LoadLevel("Game/Levels/PacificIsland");

	DoPreGameStages();
	return true;
}

bool CGame::DoPreGameStages()
{
	// Sever connection/login stage.
	m_isConnectedToServer = m_pServerConnection->Connect("localhost", "25251");
	CRY_ASSERT(m_isConnectedToServer);
	m_pServerConnection->Execute("login id passwd");
	return true;
}

void CGame::SetLocalPlayer(CPlayerPtr pLocalPlayer)
{
	if (!pLocalPlayer)
	{
		m_localActorId = 0;
		m_pLocalPlayer.reset();
		return;
	}

	IEntity* pEntity = pLocalPlayer->GetEntity();
	CRY_ASSERT(pEntity);
	CRY_SAFE_RETURN(!pEntity, CRY_NO_RETURN_VALUE);
	m_localActorId = pEntity->GetId();
	m_pLocalPlayer = pLocalPlayer;
}

IActor* CGame::GetLocalActor()
{
	IActorSystem* pActorSystem = m_pFramework->GetIActorSystem();
	return pActorSystem->GetActor(m_localActorId);
}

int CGame::Update(bool haveFocus, unsigned int updateFlags)
{
	bool bRun = m_pFramework->PreUpdate(true, updateFlags);

	float	fFrameTime = gEnv->pTimer->GetFrameTime();

	// Processes received packets from server.
	if (m_isConnectedToServer)
		m_pServerConnection->ProcessPackets();

	m_pPlayerManager->Update();

	// Updates camera view.
	IActor* pLocalActor = GetLocalActor();
	if (pLocalActor)
		m_pCameraView->Update(pLocalActor->GetEntity());

	m_pFramework->PostUpdate(true, updateFlags);

	return bRun ? 1 : 0;
}