#ifndef __GAME_H__
#define __GAME_H__

#include <IGame.h>

class CCameraView;
class CInputHandler;
class CPlayer;
class CPlayerManager;
class CTestConnection;
struct IActor;
struct IGameFramework;

extern class CGame* g_pGame;

class CGame :
	public IGame
{
public:
	CGame();
	VIRTUAL ~CGame();
	static IGame* CreateInstance(IGameFramework* pGameFramework);

	// IGame
	VIRTUAL bool Init(IGameFramework *pFramework);
	VIRTUAL bool CompleteInit();
	VIRTUAL void GetMemoryStatistics(ICrySizer * s)																{}
	VIRTUAL void Shutdown()																												{}
	VIRTUAL int Update(bool haveFocus, unsigned int updateFlags);
	VIRTUAL void ConfigureGameChannel(bool isServer, IProtocolBuilder *pBuilder)	{}
	VIRTUAL void EditorResetGame(bool bStart)																			{}
	VIRTUAL void PlayerIdSet(EntityId playerId)																		{}
	VIRTUAL IGameFramework *GetIGameFramework()																		{ return m_pFramework; }
	VIRTUAL const char *GetLongName()																							{ return NULL; }
	VIRTUAL const char *GetName()																									{ return NULL; }
	VIRTUAL void LoadActionMaps(const char* filename)															{}
	VIRTUAL void OnClearPlayerIds()																								{}
	VIRTUAL const char* CreateSaveGameName()																			{ return NULL; }
	VIRTUAL const char* GetMappedLevelName(const char *levelName) const						{ return NULL; }
	VIRTUAL IGameStateRecorder* CreateGameStateRecorder(IGameplayListener* pL)		{ return NULL; }
	VIRTUAL const bool DoInitialSavegame() const																	{ return true; }
	// ~IGame

	CCameraView*			GetCameraView()				{ return m_pCameraView.get(); }
	CPlayerManager*		GetPlayerManager()		{ return m_pPlayerManager.get(); }
	CTestConnection*	GetServerConnection()	{ return m_pServerConnection.get(); }

	void							SetLocalPlayer(std::tr1::shared_ptr<CPlayer> pLocalPlayer);
	CPlayer*					GetLocalPlayer()			{ return m_pLocalPlayer.get(); }
	bool							IsConnectedToServer()	{ return m_isConnectedToServer; }

protected:
	bool			DoPreGameStages();
	IActor*		GetLocalActor();

private:
	IGameFramework*			m_pFramework;
	IConsole*						m_pConsole;

	// Game Subsystems.
	std::auto_ptr<CInputHandler>			m_pInputHandler;
	std::auto_ptr<CCameraView>				m_pCameraView;
	std::auto_ptr<CPlayerManager>			m_pPlayerManager;
	std::auto_ptr<CTestConnection>		m_pServerConnection;

private:
	// Local player controlled by you.
	EntityId		m_localActorId;
	std::tr1::shared_ptr<CPlayer>			m_pLocalPlayer;

	bool				m_isConnectedToServer;
};

#endif // __GAME_H__