#ifndef __GAME_FRAMEWORK_H__
#define __GAME_FRAMEWORK_H__

#ifndef	USE_EXTERNAL_FRAMEWORK_DLL

#include "NullGameFramework.h"

struct ISystem;
struct ILevelSystem;
struct IActorSystem;

class CGameFramework : public NullFramework
{
public:
	CGameFramework();
	VIRTUAL ~CGameFramework();
	static IGameFramework* CreateInstance();

	// IGameFramework
	VIRTUAL bool				Init(SSystemInitParams& startupParams);	
	VIRTUAL bool				CompleteInit();
	VIRTUAL void				Shutdown();

	VIRTUAL bool				PreUpdate(bool haveFocus, unsigned int updateFlags);
	VIRTUAL void				PostUpdate(bool haveFocus, unsigned int updateFlags);

	VIRTUAL ISystem*				GetISystem()				{ return m_pSystem; }
	VIRTUAL ILevelSystem*		GetILevelSystem()		{ return m_pLevelSystem; }
	VIRTUAL IActorSystem*		GetIActorSystem()		{ return m_pActorSystem; }
	// ~IGameFramework

private:
	//- subsystems
	ISystem*						m_pSystem;
	ILevelSystem*				m_pLevelSystem;
	IActorSystem*				m_pActorSystem;

#if !defined(_LIB) && !defined(LINUX) && !defined(PS3)
	HMODULE			m_hSystemDll;
#endif	//!_LIB && !LINUX && !PS3

};

#endif // not USE_EXTERNAL_FRAMEWORK_DLL

#endif __GAME_FRAMEWORK_H__