#ifndef __IACTORSYSTEM_H__
#define __IACTORSYSTEM_H__

#if _MSC_VER > 1000
# pragma once
#endif

struct IEntity;

struct IActor : IEntityProxy {
	virtual IEntity*	GetEntity() = 0;
};

struct IActorSystem {
	virtual EntityId	CreateActor(const char* name, const Vec3& pos, const char* actorClass) = 0;
	virtual void			AddActor(EntityId entityId, IActor *pProxy) = 0;
	virtual void			RemoveActor(EntityId entityId) = 0;
	virtual IActor*		GetActor(EntityId entityId) = 0;
};

#endif  // __IACTORSYSTEM_H__