#include "StdAfx.h"
#include "InputHandler.h"

#include "CameraView.h"
#include "Game.h"
#include "PlayerManager.h"


CInputHandler::CInputHandler()
{
	gEnv->pInput->AddEventListener(this);
}

CInputHandler::~CInputHandler()
{
	gEnv->pInput->RemoveEventListener(this);
}

bool CInputHandler::OnInputEvent(const SInputEvent &event)
{
	ProcessCameraControl(event);
	ProcessLocalPlayerControl(event);
	return true;
}

void CInputHandler::ProcessCameraControl(const SInputEvent& event)
{
	static const float kRotationSpeedScale = 0.005f;

	CCameraView* pCameraView = g_pGame->GetCameraView();
	CRY_SAFE_RETURN(!pCameraView, CRY_NO_RETURN_VALUE);

	if (event.deviceId == eDI_Mouse && event.state == eIS_Changed)
	{
		if (event.keyId == eKI_MouseY)
		{
			pCameraView->IncrementAltitude(event.value * kRotationSpeedScale);
		}
	}
}

void CInputHandler::ProcessLocalPlayerControl(const SInputEvent& event)
{
	static const float kRotationSpeedScale = 0.003f;
	static const float kDistanceForSyncCycle = 0.2f;
	static const Vec3 kVec3UnitZ(0.0f, 0.0f, 1.0f);

	CPlayer* pLocalPlayer = g_pGame->GetLocalPlayer();
	CRY_SAFE_RETURN(!pLocalPlayer, CRY_NO_RETURN_VALUE);
	IEntity* pEntity = pLocalPlayer->GetEntity();
	CRY_SAFE_RETURN(!pEntity, CRY_NO_RETURN_VALUE);

	if (event.deviceId == eDI_Mouse && event.state == eIS_Changed)
	{
		if (event.keyId == eKI_MouseX)
		{
			pLocalPlayer->Request_SetYaw(pEntity->GetRotation().GetRotZ() - event.value * kRotationSpeedScale);
		}
	} 
	else if (event.deviceId == eDI_Keyboard && event.state == eIS_Down)
	{
		if (event.keyId == eKI_W)
		{
			pLocalPlayer->Request_SetMoveTarget(
				pEntity->GetPos(),
				pEntity->GetPos() + pEntity->GetForwardDir() * kDistanceForSyncCycle);
		}
		else if (event.keyId == eKI_S)
		{
			pLocalPlayer->Request_SetMoveTarget(
				pEntity->GetPos(),
				pEntity->GetPos() - pEntity->GetForwardDir() * kDistanceForSyncCycle);
		}
		else if (event.keyId == eKI_A)
		{
			Vec3 leftDir = kVec3UnitZ.Cross(pEntity->GetForwardDir());
			pLocalPlayer->Request_SetMoveTarget(
				pEntity->GetPos(),
				pEntity->GetPos() + leftDir * kDistanceForSyncCycle);
		}
		else if (event.keyId == eKI_D)
		{
			Vec3 rightDir = pEntity->GetForwardDir().Cross(kVec3UnitZ);
			pLocalPlayer->Request_SetMoveTarget(
				pEntity->GetPos(),
				pEntity->GetPos() + rightDir * kDistanceForSyncCycle);
		}
	}
	else if (event.deviceId == eDI_Keyboard && event.state == eIS_Released)
	{
		if (event.keyId == eKI_W || event.keyId == eKI_S || event.keyId == eKI_A || event.keyId == eKI_D)
		{
				pLocalPlayer->Request_SetMoveTarget(pEntity->GetPos(), pEntity->GetPos());
		}
	}
}
