#include "StdAfx.h"
#include "LevelSystem.h"

#include <IAISystem.h>
#include <IEntitySystem.h>


CLevelSystem::CLevelSystem()
{
}

CLevelSystem::~CLevelSystem()
{
}

bool CLevelSystem::LoadLevel(const char* levelName)
{
	CRY_ASSERT(levelName);
	CRY_SAFE_RETURN(!levelName, false);
	string strLevelPath = PathUtil::AddSlash(levelName);
	string strPakFile = strLevelPath + "level.pak";

	// Starts loading the level from pak file.
	gEnv->pCryPak->Notify(ICryPak::EVENT_BEGIN_LOADLEVEL);
	if(false == gEnv->pCryPak->OpenPack(strPakFile))
	{
		CryFatalError("Couldn't open pak file: %s", strPakFile);
		return false;;
	}
	if(false == gEnv->p3DEngine->LoadLevel(strLevelPath, "Mission0"))
	{
		CryFatalError("Couldn't load level: %s", strLevelPath);
		return false;
	}
	gEnv->pCryPak->Notify(ICryPak::EVENT_END_LOADLEVEL);

	//load mission xml
	//Actually, filename of the mission xml should be parsed from 'leveldataaction.xml'
	static const string kMissionXmlFileName = "Mission_Mission0.xml";
	bool bMissionXmlLoadSuccess = LoadMissionXml(strLevelPath + kMissionXmlFileName);
	CRY_ASSERT(bMissionXmlLoadSuccess);

	//AI objects are now registered, init AI system
	gEnv->pAISystem->Reset(IAISystem::RESET_ENTER_GAME);

	return true;
}

bool CLevelSystem::LoadMissionXml(const string& xmlFileName)
{
	CRY_ASSERT(gEnv);
	CRY_SAFE_RETURN(!gEnv, false);

	CRY_ASSERT(gEnv->pSystem);
	CRY_SAFE_RETURN(!gEnv->pSystem, false);

	CRY_ASSERT(gEnv->pScriptSystem);
	CRY_SAFE_RETURN(!gEnv->pScriptSystem, false);

	CRY_ASSERT(gEnv->pEntitySystem);
	CRY_SAFE_RETURN(!gEnv->pEntitySystem, false);

	XmlNodeRef rootNode = gEnv->pSystem->LoadXmlFile(xmlFileName.c_str());
	CRY_ASSERT(rootNode);
	CRY_SAFE_RETURN(!rootNode, false);

	const char* script = rootNode->getAttr("Script");
	if (script && script[0])
		gEnv->pScriptSystem->ExecuteFile(script, true, true);

	XmlNodeRef objectsNode = rootNode->findChild("Objects");
	if (objectsNode)
		gEnv->pEntitySystem->LoadEntities(objectsNode);

	return true;
}
