#ifndef __NULL_GAME_FRAMEWORK_H__
#define __NULL_GAME_FRAMEWORK_H__

#ifndef	USE_EXTERNAL_FRAMEWORK_DLL

#include <ISystem.h>
#include <IGameFramework.h>

class NullFramework : public IGameFramework 
{
public:
	NullFramework() {}
	VIRTUAL ~NullFramework() {}
	// IGameFramework
	////VIRTUAL bool		Init(SSystemInitParams& startupParams) { return true; }
	////VIRTUAL bool		CompleteInit() { return true; }
	////VIRTUAL void		Shutdown() {}

	////VIRTUAL bool		PreUpdate(bool haveFocus, unsigned int updateFlags) { return true; }
	////VIRTUAL void		PostUpdate(bool haveFocus, unsigned int updateFlags) { return true; }

	VIRTUAL void		Reset(bool clients) {}
	VIRTUAL void		PauseGame(bool pause, bool force, unsigned int nFadeOutInMS=0) {}
	VIRTUAL bool		IsGamePaused() { return false; }
	VIRTUAL bool		IsGameStarted() { return true; }

	//- subsystem access
	//for licensee: please change subsystem interface according to your needs
	////VIRTUAL ISystem*						GetISystem()						{ return NULL; }
	////VIRTUAL ILevelSystem*				GetILevelSystem()				{	return NULL;	}	//code smell: interface defined in CryAction, should be in CryCommons
	VIRTUAL IUIDraw*						GetIUIDraw()						{	return NULL;	}
	VIRTUAL IGameObjectSystem*	GetIGameObjectSystem()	{	return NULL;	}	//needed?
	////VIRTUAL IActorSystem*				GetIActorSystem()				{	return NULL;	}	//needed?
	VIRTUAL IItemSystem*				GetIItemSystem()				{	return NULL;	}	//needed?
	VIRTUAL IViewSystem*				GetIViewSystem()				{	return NULL;	}	//possibly needed
	VIRTUAL IGameplayRecorder*	GetIGameplayRecorder()	{	return NULL;	}
	VIRTUAL IVehicleSystem*			GetIVehicleSystem()			{	return NULL;	}
	VIRTUAL IGameRulesSystem*		GetIGameRulesSystem()		{	return NULL;	}	//needed?
	VIRTUAL IActionMapManager*	GetIActionMapManager()	{	return NULL;	}	
	VIRTUAL IFlowSystem*				GetIFlowSystem()				{	return NULL;	}
	VIRTUAL IGameTokenSystem*		GetIGameTokenSystem()		{	return NULL;	}
	VIRTUAL IEffectSystem*			GetIEffectSystem()			{	return NULL;	}	//for minimal framework
	VIRTUAL IMaterialEffects*		GetIMaterialEffects()		{	return NULL;	}	//for minimal framework
	VIRTUAL IDialogSystem*			GetIDialogSystem()			{	return NULL;	}	
	VIRTUAL IDebrisMgr*					GetDebrisMgr ()					{	return NULL;	}
	VIRTUAL ISubtitleManager*		GetISubtitleManager()		{	return NULL;	}
#ifdef INCLUDE_FACEGEN
	VIRTUAL IFaceGen*			CreateIFaceGen()		{	return NULL;	}		
#endif
	VIRTUAL IGameStatistics*					GetIGameStatistics()					{	return NULL;	}
	VIRTUAL IVisualLog*								GetIVisualLog()								{	return NULL;	}
	VIRTUAL ICombatLog*								GetICombatLog()								{	return NULL;	}
	VIRTUAL IMusicLogic*							GetMusicLogic()								{	return NULL;	}	//for minimal framework
	VIRTUAL IAnimationGraphState*			GetMusicGraphState()					{	return NULL;	}	//for minimal framework
	VIRTUAL	ITweakMenuController*			CreateITweakMenuController()	{	return NULL;	}
	VIRTUAL	ICheckpointSystem*				GetICheckpointSystem()				{	return NULL;	}
	VIRTUAL IForceFeedbackSystem*			GetIForceFeedbackSystem() const	{	return NULL;	}
	VIRTUAL IPlayerProfileManager*		GetIPlayerProfileManager()		{	return NULL;	}	//for savegame support?
	VIRTUAL ICharacterPartsManager*		GetICharacterPartsManager()		{	return NULL;	}
	VIRTUAL IRealtimeRemoteUpdate*		GetIRealTimeRemoteUpdate()		{	return NULL;	}	//needed: LiveCreate
	VIRTUAL ICooperativeAnimationManager* GetICooperativeAnimationManager()	{	return NULL;	}
	VIRTUAL IPersistantDebug*					GetIPersistantDebug()					{	return NULL;	}
	VIRTUAL IGameStatsConfig*					GetIGameStatsConfig()					{	return NULL;	}
	VIRTUAL IDebugHistoryManager*			CreateDebugHistoryManager()		{	return NULL;	}
	VIRTUAL IDeferredRaycastManager*	GetIDeferredRaycastManager()	{	return NULL;	}

	//- factories register
	VIRTUAL void	RegisterFactory(const char* name, IActorCreator* pCreator, bool isAI)		{}
	VIRTUAL void	RegisterFactory(const char* name, IItemCreator* pCreator, bool isAI)		{}
	VIRTUAL void	RegisterFactory(const char* name, IVehicleCreator* pCreator, bool isAI) {}
	VIRTUAL void	RegisterFactory(const char* name, IGameObjectExtensionCreator* pCreator, bool isAI ) {}
	VIRTUAL void	RegisterFactory(const char* name, IAnimationStateNodeFactory* (*func)(), bool isAI ) {}
	VIRTUAL void	RegisterFactory(const char* name, ISaveGame* (*func)(), bool) {}
	VIRTUAL void	RegisterFactory(const char* name, ILoadGame* (*func)(), bool) {}

	//- listener access
	VIRTUAL ILanQueryListener*	GetILanQueryListener() { return NULL;	}
	VIRTUAL void	RegisterListener(IGameFrameworkListener* pGameFrameworkListener, const char* name,EFRAMEWORKLISTENERPRIORITY eFrameworkListenerPriority)
	{}
	VIRTUAL void	UnregisterListener(IGameFrameworkListener* pGameFrameworkListener) {}


	//- game context
	VIRTUAL bool		StartGameContext( const SGameStartParams* pGameStartParams )			{ return true; }
	VIRTUAL bool		ChangeGameContext( const SGameContextParams* pGameContextParams ) { return true; }
	VIRTUAL void		EndGameContext() {}
	VIRTUAL bool		StartedGameContext() const { return true; }
	VIRTUAL	void		SetGameSessionHandler(IGameSessionHandler* pSessionHandler) {}

	//- breakability
	VIRTUAL void		FlushBreakableObjects()		{}
	VIRTUAL void		ResetBrokenGameObjects()	{}

	//- editor
	VIRTUAL void		InitEditor(IGameToEditorInterface* pGameToEditor)								{}
	VIRTUAL void		SetEditorLevel(const char* levelName, const char* levelFolder)	{}
	VIRTUAL void		GetEditorLevel(char** levelName, char** levelFolder)						{}
	VIRTUAL void		OnEditorSetGameMode( int iMode )																{}

	//- networking
	VIRTUAL void					BeginLanQuery()																			{}
	VIRTUAL void					EndCurrentQuery() 																	{}
	VIRTUAL INetChannel*	GetClientChannel() const														{	return NULL;	}
	VIRTUAL void					DelegateAuthority(EntityId entityId, uint16 channelId)	{}
	VIRTUAL CTimeValue		GetServerTime()																			{ return CTimeValue(); } 
	VIRTUAL uint16				GetGameChannelId(INetChannel* pNetChannel)					{ return 0; }
	VIRTUAL bool					IsChannelOnHold(uint16 channelId)										{ return true; }
	VIRTUAL INetChannel*	GetNetChannel(uint16 channelId)											{	return NULL;	}
	VIRTUAL bool					GetNetworkSafeClassId(uint16& id, const char* className) { return true; }
	VIRTUAL bool					GetNetworkSafeClassName(char* className, size_t maxn, uint16 id) { return true; }
	VIRTUAL INetNub*			GetServerNetNub()																		{	return NULL;	}
	VIRTUAL INetNub*			GetClientNetNub()																		{	return NULL;	}
	VIRTUAL INetContext*	GetNetContext()																			{	return NULL;	}

	VIRTUAL void GetMemoryUsage(ICrySizer *pSizer ) const {}

	//- player access
	VIRTUAL bool			BlockingSpawnPlayer() { return true; }
	VIRTUAL IActor*		GetClientActor() const { return NULL; }
	VIRTUAL EntityId	GetClientActorId() const { return 0; }

	//- game object
	VIRTUAL IGameObject*					GetGameObject(EntityId id)	{	return NULL;	}
	VIRTUAL IGameObjectExtension*	QueryGameObjectExtension( EntityId id, const char* name)	{	return NULL;	}

	//- save game
	VIRTUAL bool		SaveGame(const char* path, bool quick = false, bool bForceImmediate = true, ESaveGameReason reason = eSGR_QuickSave, bool ignoreDelay = false, const char* checkPoint = NULL)
	{ return true; }
	VIRTUAL bool		LoadGame(const char* path, bool quick = false, bool ignoreDelay = false) { return true; }
	VIRTUAL void		AllowLoad(bool bAllow = true)	{}
	VIRTUAL void		AllowSave(bool bAllow = true)	{}
	VIRTUAL bool		CanLoad()											{ return false; }
	VIRTUAL bool		CanSave()											{ return false; }
	VIRTUAL bool		CanCheat()										{ return true; }

	//- state query
	VIRTUAL bool		IsEditing()						{	return true; }
	VIRTUAL bool		IsInTimeDemo()				{	return false;	}
	VIRTUAL bool		IsInLevelLoad()				{ return false; }
	VIRTUAL bool		IsLoadingSaveGame()		{ return false; }

	//- level access
	VIRTUAL const char*	GetLevelName()																							{	return NULL;	}
	VIRTUAL const char*	GetAbsLevelPath(char*const pPath, const uint32 cPathMaxLen) { return NULL; }
	VIRTUAL void				PrefetchLevelAssets( const bool bEnforceAll )								{}

	//- game GUID
	VIRTUAL void				SetGameGUID(const char* gameGUID) {}
	VIRTUAL const char*	GetGameGUID()											{	return NULL;	}

	//- memory stats
	VIRTUAL void		GetMemoryStatistics(ICrySizer* ) {}
	VIRTUAL void		DumpMemInfo(const char* format, ...) PRINTF_PARAMS(2, 3) {}

	//- voice recording
	VIRTUAL void		EnableVoiceRecording(const bool enable) {}
	VIRTUAL void		MutePlayerById(EntityId mutePlayer)			{}
	VIRTUAL bool		IsVoiceRecordingEnabled()								{ return false; }

	//- AI proxies
	VIRTUAL IAIActorProxy*	GetAIActorProxy(EntityId id) const												{ return NULL; }
	VIRTUAL IAIActorProxy*	CreateAIActorProxy(IGameObject* pGameObject, EntityId id) { return NULL; }
	VIRTUAL void						DestroyAIActorProxy(EntityId id)	{}
	VIRTUAL void						DestroyAllAIActorProxies()				{}
	VIRTUAL void						DestroyUnusedAIActorProxies()			{}

	//- Multiplayer
	VIRTUAL bool		IsImmersiveMPEnabled() { return false; }

	//- Browser
	VIRTUAL void		ExecuteCommandNextFrame(const char*)	{}
	VIRTUAL void		ShowPageInBrowser(const char* URL)		{}

	//- 
	VIRTUAL bool		StartProcess(const char* cmd_line)	{ return true; }
	VIRTUAL bool		SaveServerConfig(const char* path)	{ return true; }
	VIRTUAL void		ReleaseGameStats()									{}
	// ~IGameFramework
};

#endif // not USE_EXTERNAL_FRAMEWORK_DLL

#endif __NULL_GAME_FRAMEWORK_H__