#include "StdAfx.h"
#include "PacketHandler.h"

#include "Game.h"
#include "PlayerManager.h"
#include "TestConnection.h"


CPacketHandler::CPacketHandler()
{
}

CPacketHandler::~CPacketHandler()
{
}

void CPacketHandler::Handle(const Packet::Pkt_SLogin& pkt)
{
	CTestConnection* pConnection = g_pGame->GetServerConnection();
	CRY_ASSERT(pConnection);
	CRY_SAFE_RETURN(!pConnection, CRY_NO_RETURN_VALUE);
	pConnection->Execute("myinfo");
	pConnection->Execute("otherinfo");
}

void CPacketHandler::Handle(const Packet::Pkt_SChat& pkt)
{
}

void CPacketHandler::Handle(const Packet::Pkt_SMyPlayerInfo& pkt)
{
	CPlayerManager* pPlayerManager = g_pGame->GetPlayerManager();
	CRY_ASSERT(pPlayerManager);
	CRY_SAFE_RETURN(!pPlayerManager, CRY_NO_RETURN_VALUE);
	Vec3 pos(pkt.myInfo.pos.x, pkt.myInfo.pos.y, pkt.myInfo.pos.z);
	CPlayerPtr pLocalPlayer =
		pPlayerManager->AddPlayer(pkt.myInfo.serial, pkt.myInfo.name.c_str(), pos);
	CRY_ASSERT(pLocalPlayer);
	CRY_SAFE_RETURN(!pLocalPlayer, CRY_NO_RETURN_VALUE);

	g_pGame->SetLocalPlayer(pLocalPlayer);
}

void CPacketHandler::Handle(const Packet::Pkt_SMovement& pkt)
{
	CPlayerManager* pPlayerManager = g_pGame->GetPlayerManager();
	CRY_ASSERT(pPlayerManager);
	CRY_SAFE_RETURN(!pPlayerManager, CRY_NO_RETURN_VALUE);
	CPlayerPtr pPlayer = pPlayerManager->FindPlayer(pkt.serial);
	CRY_ASSERT(pPlayer);
	CRY_SAFE_RETURN(!pPlayer, CRY_NO_RETURN_VALUE);

	Vec3 src(pkt.src.x, pkt.src.y, pkt.src.z);
	Vec3 dst(pkt.dst.x, pkt.dst.y, pkt.dst.z);
	pPlayer->SetMoveTarget(src, dst);
}

void CPacketHandler::Handle(const Packet::Pkt_SOtherPlayerInfo& pkt)
{
	CPlayerManager* pPlayerManager = g_pGame->GetPlayerManager();
	CRY_ASSERT(pPlayerManager);
	CRY_SAFE_RETURN(!pPlayerManager, CRY_NO_RETURN_VALUE);

	for (std::vector<Packet::PlayerInfo>::const_iterator it = pkt.list.begin(); it != pkt.list.end(); ++it)
	{
		Vec3 pos(it->pos.x, it->pos.y, it->pos.z);
		pPlayerManager->AddPlayer(it->serial, it->name.c_str(), pos);
	}
}

void CPacketHandler::Handle(const Packet::Pkt_SMonsterInfo& pkt)
{
}
