#include "StdAfx.h"
#ifndef UNIT_TEST
#include "PacketReceiver.h"
#include <process.h>

#include "..\Common\Packet\ServerPacket.h"
#include "PacketHandler.h"
#include "TinyClientSocket.h"

const int PacketBufferSize = 1024*2;

CPacketReceiver::CPacketReceiver() 
	: m_recvOffset(0)
	, m_parseOffset(0)
	, m_packetHandler(0)
{
	m_packetBuffer = new char[PacketBufferSize];
	m_packetHandler = new CPacketHandler;
}

CPacketReceiver::~CPacketReceiver()
{
	SAFE_DELETE_ARRAY(m_packetBuffer);
	SAFE_DELETE(m_packetHandler);
}

void CPacketReceiver::Update()
{
	const int RecviveBufferSize = 1024;
	char receiveBuffer[RecviveBufferSize] = {0,};
	uint32 receivedSize = m_socket->Receive(receiveBuffer, RecviveBufferSize, 0);
	if (0 == receivedSize)
		return;

	OnRceived(receiveBuffer, receivedSize);
	//printf("Received (%d) bytes\n", receivedSize);
}

void CPacketReceiver::SetSocket( CTinyClientSocket* s )
{
	m_socket = s;
}

void CPacketReceiver::OnRceived( const char* buffer, uint32 len )
{
	CRY_ASSERT(m_packetHandler);
	ApplyBuffer(buffer, len);
	Packet::ParseServerPacket(*m_packetHandler, m_packetBuffer, m_parseOffset, m_recvOffset);
	if (m_parseOffset == m_recvOffset)
	{
		m_parseOffset = 0;
		m_recvOffset = 0;
	}
}

bool CPacketReceiver::ApplyBuffer( const char* buffer, uint32 len )
{
	if ((m_recvOffset+len)>PacketBufferSize)
		return false;

	memcpy(&m_packetBuffer[m_recvOffset], buffer, len);
	m_recvOffset += len;
	return true;
}

#endif 