#pragma once

class CPacketHandler;
class CTinyClientSocket;

class CPacketReceiver
{
public:
	CPacketReceiver(void);
	~CPacketReceiver(void);

public:
	void SetSocket(CTinyClientSocket* s);
	void Update();

protected:
	void OnRceived(const char* buffer, uint32 len);
	bool ApplyBuffer(const char* buffer, uint32 len);

private:
	volatile long m_threadStopRequest;
	volatile long m_threadFinished;
	CTinyClientSocket* m_socket;
	char* m_packetBuffer;
	int m_recvOffset;
	int m_parseOffset;
	CPacketHandler* m_packetHandler;
};
