#ifndef __PLAYER_MANAGER_H__
#define __PLAYER_MANAGER_H__

class CPacketHandler;
class CPlayer;
typedef std::tr1::shared_ptr<CPlayer> CPlayerPtr;
typedef std::map<uint, CPlayerPtr> PlayerMap;

class CPlayer 
{
	friend class CPacketHandler;

public:
	CPlayer(const EntityId id);
	~CPlayer();

	bool Update();
	IEntity* GetEntity();

	void Request_SetMoveTarget(const Vec3& currentPos, const Vec3& moveTarget);
	void Request_SetYaw(const float yawRad);

protected:
	void SetMoveTarget(const Vec3& currentPos, const Vec3& moveTarget);
	void SetYaw(const float yawRad);

private:
	EntityId m_entityId;

	bool m_hasMoveTarget;
	Vec3 m_startPoint;
	Vec3 m_moveTarget;

	bool m_hasTargetYaw;
	float m_targetYawRad;
};

class CPlayerManager
{
public:
	CPlayerManager();
	~CPlayerManager();

	CPlayerPtr AddPlayer(const uint id, const char* name, const Vec3& pos);
	CPlayerPtr FindPlayer(const uint id);
	void RemovePlayer(const uint id);

	bool Update();

private:
	PlayerMap m_playerMap;

	DISALLOW_COPY_AND_ASSIGN(CPlayerManager);
};

#endif // __PLAYER_MANAGER_H__