#include "StdAfx.h"
#include "Resource.h"
#include "LevelLoader.h"
#include "CryEngineApp.h"

// This header must be included only once! in each module or executable
#include <platform_impl.h>
#include <IConsole.h>
#include <I3DEngine.h>

#include "NetworkServer.h"

extern HINSTANCE g_hInstance;


void Error( const char* sErrorText )
{
	MessageBox( 0,sErrorText, "Error", MB_OK | MB_DEFAULT_DESKTOP_ONLY);
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
// ctor & dtor

static const Vec3 s_vStartPos(1326, 1346, 140);
static const Ang3 s_aStartAng(DEG2RAD( -10 ), 0, DEG2RAD( 17 ));

CCryEngineApp::CCryEngineApp() 
	: m_hSystemHandle(0)
	, m_pISystem(0)
	, m_vCamPos(s_vStartPos)
	, m_vCamAng(s_aStartAng)
	, m_networkServer(new CNetworkServer())
{

}

//-----------------------------------

CCryEngineApp::~CCryEngineApp()
{
	if (m_hSystemHandle)
		CryFreeLibrary(m_hSystemHandle);

	if (m_networkServer)
	{
		delete m_networkServer;
		m_networkServer = NULL;
	}
}

// ctor & dtor/
//////////////////////////////////////////////////////////////////////////

bool CCryEngineApp::InitCrySystem( const char* sInCmdLine )
{
	if (!InitWindowClass())
	{
		Error( "Failed to initialize window class" );
	}

	m_hSystemHandle = LoadLibrary( "CrySystem.dll" );
	if (!m_hSystemHandle)
	{
		Error( "CrySystem.DLL Loading Failed" );
		return false;
	}

	PFNCREATESYSTEMINTERFACE pfnCreateSystemInterface = (PFNCREATESYSTEMINTERFACE)::GetProcAddress( m_hSystemHandle,DLL_INITFUNC_SYSTEM );

	SSystemInitParams sip;
	sip.bEditor = false;
	sip.bDedicatedServer = true;
	sip.bPreview = false;
	sip.bTestMode = false;
	sip.hInstance = g_hInstance;

	sip.sLogFileName = "SampleMMOServer.log";
	strcpy( sip.szSystemCmdLine,sInCmdLine );

	m_pISystem = pfnCreateSystemInterface( sip );
	if (!m_pISystem)
	{
		Error( "CreateSystemInterface Failed" );

		return false;
	}

	// Initialized important global variables like GetISystem() gEnv etc.. 
	ModuleInitISystem(m_pISystem,"Launcher");

	// System is fully initialized and ready by now.

	//gEnv->pInput->AddEventListener(this);

	InitCVars();

	if (InitNetwork())
		CryLog("Network init success.");
	else
		CryLog("Network init fail.");

	return true;
}

//-----------------------------------

bool CCryEngineApp::InitWindowClass()
{
	HINSTANCE hInstance = g_hInstance;

	WNDCLASS wc;
	memset(&wc, 0, sizeof(WNDCLASS));
	wc.style		 = CS_OWNDC | CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wc.lpfnWndProc   = (WNDPROC)CCryEngineApp::WndProc;
	wc.cbClsExtra	= 0;
	wc.cbWndExtra	= 0;
	wc.hInstance	 = GetModuleHandle(0);
	wc.hIcon		 = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_GAMESERVER));
	wc.hCursor	   = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground =(HBRUSH)GetStockObject(BLACK_BRUSH);
	wc.lpszMenuName  = 0;
	wc.lpszClassName = CRYENGINE_WINDOW_CLASSNAME;

	if (!RegisterClass(&wc))
	{
		return false;
	}
	//::ShowCursor(FALSE);
	return true;
}

//-----------------------------------

LRESULT CALLBACK CCryEngineApp::WndProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch(msg)
	{
	case WM_CLOSE:
		if (gEnv && gEnv->pSystem)
			gEnv->pSystem->Quit();
		return 0;
	case WM_HOTKEY:
	case WM_SYSCHAR:	// prevent ALT + key combinations from creating 'ding' sounds
		return  0;
	case WM_CHAR:
		break;
	case WM_MOVE:
		if(gEnv && gEnv->pSystem)
		{
			gEnv->pSystem->GetISystemEventDispatcher()->OnSystemEvent(ESYSTEM_EVENT_MOVE,LOWORD(lParam), HIWORD(lParam));
		}
		break;
	case WM_SIZE:
		if(gEnv && gEnv->pSystem)
		{
			gEnv->pSystem->GetISystemEventDispatcher()->OnSystemEvent(ESYSTEM_EVENT_RESIZE,LOWORD(lParam), HIWORD(lParam));
		}
		break;
	}

	return DefWindowProc(hWnd, msg, wParam, lParam);
}

//-----------------------------------

int CCryEngineApp::MainLoop()
{
	bool bQuit = false;
	// Main message loop and per frame engine update
	MSG msg;
	while (!bQuit)
	{
		while (PeekMessage(&msg, 0, 0, 0,PM_REMOVE))
		{
			if (msg.message == WM_QUIT)
				bQuit = true;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}

		UpdateCamera();

		// Basic frame update.
		m_pISystem->Update();
		m_pISystem->RenderBegin();
		m_pISystem->Render();
		m_pISystem->RenderEnd();

		gEnv->p3DEngine->SyncProcessStreamingUpdate();
	}
	return 0;
}

//-----------------------------------

void CCryEngineApp::UpdateCamera()
{
	CCamera cam = GetISystem()->GetViewCamera();
	cam.SetAngles( m_vCamAng );
	cam.SetPosition( m_vCamPos );
	GetISystem()->SetViewCamera( cam );
}

//////////////////////////////////////////////////////////////////////////

void CCryEngineApp::InitCVars()
{
	IConsole * pC = ::gEnv->pConsole;
	REGISTER_STRING("sv_map", "nolevel", 0, "The map the server should load");

	const char * defaultGameRules = "SinglePlayer";
	ICVar* pDefaultGameRules = REGISTER_STRING("sv_gamerulesdefault", defaultGameRules, 0, "The game rules that the server default to when disconnecting");
	const char * currentGameRules = pDefaultGameRules->GetString();
	REGISTER_STRING("sv_gamerules", currentGameRules, 0, "The game rules that the server should use");
}

bool CCryEngineApp::InitNetwork()
{
	return m_networkServer->Init();
}
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////