#include "StdAfx.h"
#include "Monster.h"

//////////////////////////////////////////////////////////////////////////
uint32 GetNewMonsterSerial()
{
	static uint32 monsterSerial = 5000;
	return ++monsterSerial;
}

//////////////////////////////////////////////////////////////////////////

CMonsterManager::CMonsterManager()
{

}

CMonsterManager::~CMonsterManager()
{

}

void CMonsterManager::Register(uint32 entityId, const char* name, const char* className, const SPosition& pos)
{
	SMonster monster;
	monster.entityId = entityId;
	monster.name = name;
	monster.className = className;
	monster.serial = GetNewMonsterSerial();
	monster.pos = pos;
	Add(monster);
}

void CMonsterManager::Unregister( int serial )
{
}

void CMonsterManager::Add( const SMonster& monster )
{
	m_monsterVector.push_back(monster);
}

void CMonsterManager::Remove( uint32 serial )
{
}

const MonsterVector& CMonsterManager::GetMonsterVector()
{
	return m_monsterVector;
}

void CMonsterManager::AddTagPoint( uint32 entityId, const SPosition& pos )
{
	MonsterVector::iterator curIter = m_monsterVector.begin();
	MonsterVector::iterator endIter = m_monsterVector.end();
	for(; curIter != endIter; ++curIter)
	{
		if ( entityId != (*curIter).entityId )
			continue;

		(*curIter).route.push_back(pos);
	}
}