#pragma once

#include "../Common/ClientServerCommon.h"

struct SMonster
{
	uint32 serial;
	uint32 entityId;
	std::string name;
	std::string className;
	SPosition pos;
	std::vector<SPosition> route;
};

typedef std::vector<SMonster> MonsterVector; 
typedef MonsterVector::const_iterator MonsterIter;

class CMonsterManager
{
public:
	CMonsterManager();
	~CMonsterManager();

public:
	void Register(uint32 entityId, const char* name, const char* className, const SPosition& pos);
	void Unregister(int serial);
	void AddTagPoint(uint32 entityId, const SPosition& pos);
	const MonsterVector& GetMonsterVector();

protected:
	void Add(const SMonster& monster);
	void Remove(uint32 serial);

private:
	MonsterVector m_monsterVector;
};

typedef ACE_Singleton<CMonsterManager, ACE_Thread_Mutex> CMonsterManagerSingleton;
#define MonsterMgr CMonsterManagerSingleton::instance()

