#include "stdafx.h"
#include "NetworkClient.h"
#include <ISystem.h>
#include "..\Common\Packet\ClientPacket.h"
#include "..\Common\Packet\ServerPacket.h"
#include "SendHelper.h"
#include "Monster.h"
#include "Player.h"

//////////////////////////////////////////////////////////////////////////

const int SendBufferSize = 1024;
const int PacketBufferSize = 1024*2;

class TestPacketHandlerImpl : public Packet::ClientPacketHandler 
{
public:
	TestPacketHandlerImpl(uint32 streamId, CSendHelper* helper) 
		: m_streamId(streamId)
		, m_sendHelper(helper)
	{}

	virtual void Handle(const Packet::Pkt_CLogin& pkt)
	{
		CryLog("LoginRequest username(%s)", pkt.username.c_str());
		PlayerMgr->Register(m_streamId, pkt.username);
		uint32 serial = PlayerMgr->GetPlayerSerialByStreamId(m_streamId);
		Packet::Pkt_SLogin loginResult;
		loginResult.succeed = true;
		loginResult.serial = serial;
		char sendBuffer[SendBufferSize] = {0,};
		int offset = 0;
		Packet::SerializeT(loginResult, sendBuffer, offset, SendBufferSize);
		m_sendHelper->Send(m_streamId, sendBuffer, offset);

		SPlayer player;
		if (false == PlayerMgr->GetPlayerByStreamId(m_streamId, player))
			return;

		Packet::Pkt_SOtherPlayerInfo otherPlayerInfo;
		Packet::PlayerInfo info;
		info.serial = player.serial;
		info.name = player.name;
		info.pos = player.pos;
		otherPlayerInfo.list.push_back(info);
		offset = 0;
		Packet::SerializeT(otherPlayerInfo, sendBuffer, offset, SendBufferSize);
		m_sendHelper->BroadcastButExceptOne(sendBuffer, offset, m_streamId);
	};

	virtual void Handle(const Packet::Pkt_CMyPlayerInfo& pkt)
	{
		CryLog("MyPlayerInfo streamId(%d)", m_streamId);
		SPlayer player;
		if (false == PlayerMgr->GetPlayerByStreamId(m_streamId, player))
			return;
		
		Packet::Pkt_SMyPlayerInfo send;
		send.myInfo.serial = player.serial;
		send.myInfo.name = player.name;
		send.myInfo.pos = player.pos;

		char sendBuffer[SendBufferSize] = {0,};
		int offset = 0;
		Packet::SerializeT(send, sendBuffer, offset, SendBufferSize);
		m_sendHelper->Send(m_streamId, sendBuffer, offset);
	};

	virtual void Handle(const Packet::Pkt_COtherPlayerInfo& pkt)
	{
		CryLog("OtherPlayerInfo streamId(%d)", m_streamId);
		SPlayer myPlayer;
		if (false == PlayerMgr->GetPlayerByStreamId(m_streamId, myPlayer))
			return;

		Packet::Pkt_SOtherPlayerInfo send;
		const PlayerVector& playerVector = PlayerMgr->GetPlayerVector();
		PlayerIter curIter = playerVector.begin();
		PlayerIter endIter = playerVector.end();
		for(; curIter != endIter; ++curIter)
		{
			if ((*curIter).serial == myPlayer.serial)
				continue;

			Packet::PlayerInfo info;
			info.serial = (*curIter).serial;
			info.name = (*curIter).name;
			info.level = 0;
			info.pos = (*curIter).pos;
			send.list.push_back(info);
		}
		char sendBuffer[SendBufferSize] = {0,};
		int offset = 0;
		Packet::SerializeT(send, sendBuffer, offset, SendBufferSize);
		m_sendHelper->Send(m_streamId, sendBuffer, offset);
	};

	virtual void Handle(const Packet::Pkt_CMonsterInfo& pkt)
	{
		SPlayer myPlayer;
		if (false == PlayerMgr->GetPlayerByStreamId(m_streamId, myPlayer))
			return;
		CryLog("MonsterListRequest");
		Packet::Pkt_SMonsterInfo send;

		const MonsterVector& monsterVector = MonsterMgr->GetMonsterVector();

		MonsterIter curIter = monsterVector.begin();
		MonsterIter endIter = monsterVector.end();
		for(; curIter != endIter; ++curIter)
		{
			Packet::PlayerInfo info;
			info.serial = (*curIter).serial;
			info.name = (*curIter).name;
			info.className = (*curIter).className;
			info.level = 0;
			info.pos = (*curIter).pos;
			send.list.push_back(info);
		}

		char sendBuffer[SendBufferSize] = {0,};
		int offset = 0;
		Packet::SerializeT(send, sendBuffer, offset, SendBufferSize);
		m_sendHelper->Send(m_streamId, sendBuffer, offset);
	};

	virtual void Handle(const Packet::Pkt_CMovement& pkt)
	{
		SPlayer myPlayer;
		if (false == PlayerMgr->GetPlayerByStreamId(m_streamId, myPlayer))
			return;
		CryLog("CMovement");
		uint32 serial = PlayerMgr->GetPlayerSerialByStreamId(m_streamId);

		Packet::Pkt_SMovement sMovement;
		sMovement.serial = serial;
		sMovement.src = pkt.src;
		sMovement.dst = pkt.dst;
		char sendBuffer[SendBufferSize] = {0,};
		int offset = 0;
		Packet::SerializeT(sMovement, sendBuffer, offset, SendBufferSize);
		m_sendHelper->Broadcast(sendBuffer, offset);
		PlayerMgr->SetPlayerMovement(m_streamId, pkt.src, pkt.dst);
	};

	virtual void Handle(const Packet::Pkt_CChat& pkt)
	{
		SPlayer myPlayer;
		if (false == PlayerMgr->GetPlayerByStreamId(m_streamId, myPlayer))
			return;
		CryLog("Chat message(%s)", pkt.message.c_str());
		uint32 serial = PlayerMgr->GetPlayerSerialByStreamId(m_streamId);
		Packet::Pkt_SChat sendChat;
		sendChat.serial = serial;
		sendChat.message = pkt.message;
		char sendBuffer[SendBufferSize] = {0,};
		int offset = 0;
		Packet::SerializeT(sendChat, sendBuffer, offset, SendBufferSize);
		m_sendHelper->Broadcast(sendBuffer, offset);
	};
	
private:
	uint32 m_streamId;
	CSendHelper* m_sendHelper;
};

//////////////////////////////////////////////////////////////////////////

CNetworkClient::CNetworkClient(uint32 streamId, CSendHelper* helper) 
	: m_streamId(streamId)
	, m_sendHelper(helper)
	, m_recvOffset(0)
	, m_parseOffset(0)
{
	m_packetBuffer = new char[PacketBufferSize];
}

CNetworkClient::~CNetworkClient()
{
	delete [] m_packetBuffer;
	m_packetBuffer = NULL;
}

void CNetworkClient::OnAccept(const char* buffer, uint32 len)
{
	CryLog("[%02d]Accept\n", m_streamId);
	m_remoteIp = std::string(buffer, len);
}

void CNetworkClient::OnReceive(const char* buffer, uint32 len)
{
	//CryLog("[%02d]Receive (%d)bytes\n", m_streamId, len);
	ApplyBuffer(buffer, len);
	TestPacketHandlerImpl handler(m_streamId, m_sendHelper);
	Packet::ParseClientPacket(handler, m_packetBuffer, m_parseOffset, m_recvOffset);
	if (m_parseOffset == m_recvOffset)
	{
		m_parseOffset = 0;
		m_recvOffset = 0;
	}
}

void CNetworkClient::OnClose()
{
	CryLog("[%02d]Close\n", m_streamId);
	PlayerMgr->Unregister(m_streamId);
}

bool CNetworkClient::ApplyBuffer( const char* buffer, uint32 len )
{
	if ((m_recvOffset+len)>PacketBufferSize)
		return false;

	memcpy(&m_packetBuffer[m_recvOffset], buffer, len);
	m_recvOffset += len;
	return true;
}