#ifndef __networkclient_h__
#define __networkclient_h__

#pragma once

class CSendHelper;

class CNetworkClient 
{
public:
	CNetworkClient(uint32 streamId, CSendHelper* helper);
	~CNetworkClient();

	void	OnAccept(const char* buffer, uint32 len);
	void	OnReceive(const char* buffer, uint32 len);
	void	OnClose();

protected:
	bool ApplyBuffer(const char* buffer, uint32 len);

private:
	uint32 m_streamId;
	std::string m_remoteIp;
	CSendHelper* m_sendHelper;
	char* m_packetBuffer;
	int m_recvOffset;
	int m_parseOffset;

};

#endif // __networkclient_h__
