#ifndef __networkserver_h__
#define __networkserver_h__

#pragma once

#include <Drei/ThreadPool.h>
#include <Drei/TsidMap.h>

class CNetworkClient;
class CSendHelper;
namespace DreiNetwork
{
	struct MessagePostee;
	class Logger;
}

class CNetworkServer : public DreiNetwork::ThreadPool
{
public:
	typedef DreiNetwork::TsMapT<CNetworkClient, 1024>	ClientMapType;
	CNetworkServer();
	~CNetworkServer(void);

	bool	Init();
	void	Fini();

public:
	virtual bool	Begin() { return true; }
	virtual void	Update();
	virtual void	End() {}

protected:
	void	OnAccept(DreiNetwork::MessagePostee& postee, const char* buffer, uint32 len);
	void	OnReceive(DreiNetwork::MessagePostee& postee, const char* buffer, uint32 len);
	void	OnClose(DreiNetwork::MessagePostee& postee);

private:
	bool m_init;
	ClientMapType* m_clientMap;
	CSendHelper* m_sendHelper;
};

#endif // __networkserver_h__