#include "StdAfx.h"
#include "Player.h"

//////////////////////////////////////////////////////////////////////////

uint32 GetNewPlayerSerial()
{
	static uint32 playerSerial = 0;
	return ++playerSerial;
}

//////////////////////////////////////////////////////////////////////////

CPlayerManager::CPlayerManager()
{

}

CPlayerManager::~CPlayerManager()
{

}

void CPlayerManager::AddSpawnPoint( const SPosition& pos )
{
	m_spawnPoint = pos;
}

void CPlayerManager::Register(uint32 streamId, const std::string& name)
{
	SPlayer element;
	element.streamId = streamId;
	element.serial = GetNewPlayerSerial();
	element.name = name;
	element.pos = GetSpawnPoint();
	Add(element);
}

void CPlayerManager::Unregister( uint32 streamId )
{
	Remove(streamId);
}

void CPlayerManager::Add( const SPlayer& element )
{
	m_playerVector.push_back(element);
	AddIndex(element.serial);
}

void CPlayerManager::Remove( uint32 streamId )
{
	PlayerVector::iterator curIter = m_playerVector.begin();
	PlayerVector::iterator endIter = m_playerVector.end();
	uint32 serial = 0;
	bool findIt = false;
	for(; curIter != endIter; ++curIter)
	{
		if ( (*curIter).streamId != streamId )
			continue;

		serial = (*curIter).serial;
		m_playerVector.erase(curIter);
		findIt = true;
		break;
	}
	if (findIt)
		RemoveIndex(serial);
}

const SPosition& CPlayerManager::GetSpawnPoint()
{
	return m_spawnPoint;
}

const PlayerVector& CPlayerManager::GetPlayerVector()
{
	return m_playerVector;
}

bool CPlayerManager::GetPlayerByStreamId( uint32 streamId, SPlayer& player )
{
	IndexMap::iterator findIter = m_streamIdIndexMap.find(streamId);
	if (m_streamIdIndexMap.end() == findIter)
		return false;

	uint32 arrayIndex = (*findIter).second;
	player = m_playerVector[arrayIndex];
	return true;
}

bool CPlayerManager::GetPlayerBySerial( uint32 serial, SPlayer& player )
{
	IndexMap::iterator findIter = m_serialIndexMap.find(serial);
	if (m_serialIndexMap.end() == findIter)
		return false;

	uint32 arrayIndex = (*findIter).second;
	player = m_playerVector[arrayIndex];
	return true;
}

uint32 CPlayerManager::GetPlayerSerialByStreamId( uint32 streamId )
{
	SPlayer player;
	if (false == GetPlayerByStreamId(streamId, player))
		return InvalidID;
	return player.serial;
}

void CPlayerManager::AddIndex( uint32 serial )
{
	PlayerIter curIter = m_playerVector.begin();
	PlayerIter endIter = m_playerVector.end();
	int index = 0;
	for(;curIter != endIter; ++curIter)
	{
		if ( (*curIter).serial == serial )
		{
			m_serialIndexMap.insert(std::make_pair((*curIter).serial, index));
			m_streamIdIndexMap.insert(std::make_pair((*curIter).streamId, index));
			break;
		}
		++index;
	}
}

void CPlayerManager::RemoveIndex( uint32 serial )
{
	PlayerIter curIter = m_playerVector.begin();
	PlayerIter endIter = m_playerVector.end();
	int index = 0;
	for(;curIter != endIter; ++curIter)
	{
		if ( (*curIter).serial != serial )
			continue;

		IndexMap::iterator removeIter = m_serialIndexMap.find(serial);
		if (removeIter != m_serialIndexMap.end())
			m_serialIndexMap.erase(removeIter);
		removeIter = m_streamIdIndexMap.find(serial);
		if (removeIter != m_streamIdIndexMap.end())
			m_streamIdIndexMap.erase(removeIter);
		break;
	}
}

void CPlayerManager::SetPlayerMovement( uint32 streamId, const SPosition& src, const SPosition& dst )
{
	IndexMap::iterator findIter = m_streamIdIndexMap.find(streamId);
	if (m_streamIdIndexMap.end() == findIter)
		return;

	uint32 arrayIndex = (*findIter).second;
	m_playerVector[arrayIndex].pos = dst;
}