#pragma once

#include "../Common/ClientServerCommon.h"
#include <map>

struct SPlayer
{
	uint32 serial;
	uint32 streamId;
	std::string name;
	SPosition pos;
};

typedef std::vector<SPlayer> PlayerVector; 
typedef PlayerVector::const_iterator PlayerIter;

class CPlayerManager
{
public:
	CPlayerManager();
	~CPlayerManager();

public:
	void Register(uint32 streamId, const std::string& name);
	void Unregister(uint32 streamId);
	const PlayerVector& GetPlayerVector();
	void AddSpawnPoint(const SPosition& pos);
	const SPosition& GetSpawnPoint();
	bool GetPlayerByStreamId(uint32 streamId, SPlayer& player);
	bool GetPlayerBySerial(uint32 serial, SPlayer& player);
	uint32 GetPlayerSerialByStreamId(uint32 streamId);

	void SetPlayerMovement(uint32 streamId, const SPosition& src, const SPosition& dst);

protected:
	void Add(const SPlayer& player);
	void Remove(uint32 streamId);
	void AddIndex(uint32 serial);
	void RemoveIndex(uint32 serial);


private:
	PlayerVector m_playerVector;
	SPosition m_spawnPoint;

	typedef std::map<uint32, uint32> IndexMap;
	IndexMap m_serialIndexMap;
	IndexMap m_streamIdIndexMap;
};

typedef ACE_Singleton<CPlayerManager, ACE_Thread_Mutex> CPlayerManagerSingleton;
#define PlayerMgr CPlayerManagerSingleton::instance()

