#include "StdAfx.h"
#include "SendHelper.h"
#include <Drei/NetworkFacade.h>

CSendHelper::CSendHelper(void)
{
}

CSendHelper::~CSendHelper(void)
{
}

void CSendHelper::AddStream(uint32 id)
{
	m_streamIdVector.push_back(id);
}

void CSendHelper::DeleteStream(uint32 id)
{
	StreamIdVector::const_iterator curIter = m_streamIdVector.begin();
	StreamIdVector::const_iterator endIter = m_streamIdVector.end();
	for(;curIter != endIter; ++curIter)
	{
		if (*curIter == id)
			break;
	}
	if (curIter != endIter)
		m_streamIdVector.erase(curIter);
}

void CSendHelper::Send( uint32 streamId, const char* buffer, uint32 len )
{
	ACE_Message_Block* sendBlock = new ACE_Message_Block(len);
	sendBlock->copy(buffer, len);
	NetworkInstance->SendRequest(streamId, sendBlock);
}

void CSendHelper::Broadcast( const char* buffer, uint32 len )
{
	StreamIdVector::const_iterator curIter = m_streamIdVector.begin();
	StreamIdVector::const_iterator endIter = m_streamIdVector.end();
	for(;curIter != endIter; ++curIter)
	{
		uint32 streamId = *curIter;
		ACE_Message_Block* sendBlock = new ACE_Message_Block(len);
		sendBlock->copy(buffer, len);
		NetworkInstance->SendRequest(streamId, sendBlock);
	}
}

void CSendHelper::BroadcastButExceptOne( const char* buffer, uint32 len, uint32 exceptStreamId )
{
	StreamIdVector::const_iterator curIter = m_streamIdVector.begin();
	StreamIdVector::const_iterator endIter = m_streamIdVector.end();
	for(;curIter != endIter; ++curIter)
	{
		uint32 streamId = *curIter;
		if (exceptStreamId == streamId)
			continue;
		ACE_Message_Block* sendBlock = new ACE_Message_Block(len);
		sendBlock->copy(buffer, len);
		NetworkInstance->SendRequest(streamId, sendBlock);
	}
}