#pragma once

#include <vector>

class CSendHelper
{
public:
	CSendHelper(void);
	~CSendHelper(void);

public:
	void AddStream(uint32 id);
	void DeleteStream(uint32 id);
	void Send(uint32 streamId, const char* buffer, uint32 len);
	void Broadcast(const char* buffer, uint32 len);
	void BroadcastButExceptOne(const char* buffer, uint32 len, uint32 exceptStreamId);

private:
	typedef std::vector<uint32> StreamIdVector;
	StreamIdVector m_streamIdVector;
};
