#include "StdAfx.h"

#ifdef UNIT_TEST
#include "PacketTestcase.h"
#include "assert.h"
#include "..\Common\Packet\TestPacket.h"

class CTestFunctionPrint
{
public:
	CTestFunctionPrint(const char* functionname) : m_functionname(functionname)
	{
		printf("Begin %s\n", m_functionname);
	}

	~CTestFunctionPrint()
	{
		printf("Finsh %s\n", m_functionname);
	}

private:
	const char* m_functionname;
};

void CPacketTestcase::Run()
{
	BasicFuctionOnPacketCommon();
	MakeBufferNormalPacket();
	MakeBufferVectorPacket();
	GluePacket();
	PacketHandlerTest();
	printf("\nPacketTest success.");
}

void CPacketTestcase::BasicFuctionOnPacketCommon()
{
	CTestFunctionPrint autoPrint(__FUNCTION__);

	const int BufferLen = 1024;
	char buffer[BufferLen] = {0,};
	Packet::SChat src;
	src.chatType = 2;
	src.message = "Hello world!";
	int offset = 0;
	Packet::SerializeT(src, buffer, offset, BufferLen);

	offset = 0;
	assert(Packet::Chat == Packet::GetPacketType(buffer, offset, BufferLen));
	offset = 0;
	size_t ss = Packet::SizeT(src);
	size_t ss0 = Packet::GetPacketLength(buffer, offset, BufferLen);
	assert(Packet::SizeT(src) == Packet::GetPacketLength(buffer, offset, BufferLen));
}

void CPacketTestcase::MakeBufferNormalPacket()
{
	CTestFunctionPrint autoPrint(__FUNCTION__);

	const int BufferLen = 1024;
	char buffer[BufferLen] = {0,};
	Packet::SLoginResponse src;
	src.level = 41;
	src.sessionId = 882632;
	src.succeed = true;
	int offset = 0;
	Packet::SerializeT(src, buffer, offset, BufferLen);

	Packet::SLoginResponse dst;
	offset = 0;
	Packet::DeserializeT(dst, buffer, offset, BufferLen);

	assert(src.level == dst.level);
	assert(src.sessionId == dst.sessionId);
	assert(src.succeed == dst.succeed);
	assert(SizeT(src) == SizeT(dst));
}

void CPacketTestcase::MakeBufferVectorPacket()
{
	CTestFunctionPrint autoPrint(__FUNCTION__);

	const int BufferLen = 1024;
	char buffer[BufferLen] = {0,};
	Packet::SPlayerListResponse src;
	Packet::PlayerInfoOld info;
	info.serial = 12;
	info.name = "rabbit";
	info.level = 8;
	src.playerList.push_back(info);
	info.serial = 17;
	info.name = "jack";
	info.level = 14;
	src.playerList.push_back(info);
	int offset = 0;
	Packet::SerializeT(src, buffer, offset, BufferLen);
	uint32 writtenSize = offset;
	offset = 0;
	Packet::SPlayerListResponse dst;
	Packet::DeserializeT(dst, buffer, offset, writtenSize);

	assert(src.playerList.size() == dst.playerList.size());
	for(size_t i=0;i<src.playerList.size(); ++i)
	{
		assert(src.playerList[i].serial == src.playerList[i].serial);
		assert(src.playerList[i].name == dst.playerList[i].name);
		assert(src.playerList[i].level == dst.playerList[i].level);
	}
	assert(SizeT(src) == SizeT(dst));
}

void CPacketTestcase::GluePacket()
{
	CTestFunctionPrint autoPrint(__FUNCTION__);

	const int BufferLen = 1024;
	char buffer[BufferLen] = {0,};
	Packet::SLoginResponse srcLogin;
	srcLogin.level = 41;
	srcLogin.sessionId = 882632;
	srcLogin.succeed = false;
	int offset = 0;
	Packet::SerializeT(srcLogin, buffer, offset, BufferLen);

	Packet::SChat srcChat;
	srcChat.chatType = 2;
	srcChat.message = "Hello world!";
	Packet::SerializeT(srcChat, buffer, offset, BufferLen);

	offset = 0;
	Packet::PacketType pt0 = Packet::GetPacketType(buffer, offset, BufferLen);
	Packet::PacketLenType pl0 = Packet::GetPacketLength(buffer, offset, BufferLen);
	assert(Packet::LoginResponse == pt0);
	assert(Packet::SizeT(srcLogin) == pl0);
	Packet::SLoginResponse dstLogin;
	offset = 0;
	Packet::DeserializeT(dstLogin, buffer, offset, BufferLen);
	assert(srcLogin.level == dstLogin.level);
	assert(srcLogin.sessionId == dstLogin.sessionId);
	assert(srcLogin.succeed == dstLogin.succeed);
	assert(SizeT(srcLogin) == SizeT(dstLogin));
	
	Packet::PacketType pt1 = Packet::GetPacketType(buffer, offset, BufferLen);
	Packet::PacketLenType pl1 = Packet::GetPacketLength(buffer, offset, BufferLen);
	assert(Packet::Chat == pt1);
	assert(Packet::SizeT(srcChat) == pl1);
	Packet::SChat dstChat;
	Packet::DeserializeT(dstChat, buffer, offset, BufferLen);
	assert(srcChat.chatType == dstChat.chatType);
	assert(srcChat.message == dstChat.message);
	assert(Packet::SizeT(srcChat) == Packet::SizeT(dstChat));
}

void CPacketTestcase::PacketHandlerTest()
{
	CTestFunctionPrint autoPrint(__FUNCTION__);

	const int BufferLen = 1024;
	char buffer[BufferLen] = {0,};
	Packet::SLoginResponse srcLogin;
	srcLogin.level = 41;
	srcLogin.sessionId = 882632;
	srcLogin.succeed = true;
	int offset = 0;
	Packet::SerializeT(srcLogin, buffer, offset, BufferLen);

	Packet::SChat srcChat;
	srcChat.chatType = 2;
	srcChat.message = "Hello worldddd!";
	Packet::SerializeT(srcChat, buffer, offset, BufferLen);

	class TestPacketHandlerImpl : public Packet::TestPacketHandler 
	{
	public:
		virtual void Handle(const Packet::SLoginResponse& pkt)
		{
			assert(m_login.succeed == pkt.succeed);
			assert(m_login.sessionId == pkt.sessionId);
			assert(m_login.level == pkt.level);
		}

		virtual void Handle(const Packet::SChat& pkt)
		{
			assert(m_chat.chatType == pkt.chatType);
			assert(m_chat.message == pkt.message);
		}

		Packet::SLoginResponse m_login;
		Packet::SChat m_chat;
	};

	TestPacketHandlerImpl handler;
	handler.m_login = srcLogin;
	handler.m_chat = srcChat;
	offset = 0;
	Packet::ParsePacket(handler, buffer, offset, BufferLen);

}
#endif