#include "StdAfx.h"
#ifndef UNIT_TEST
#include "ReceiveThread.h"
#include <process.h>
#include "TinyClientSocket.h"
#include "..\Common\Packet\ServerPacket.h"

const int PacketBufferSize = 1024*2;

class TestPacketHandlerImpl : public Packet::ServerPacketHandler 
{
public:
	virtual void Handle(const Packet::Pkt_SLogin& pkt)
	{
		printf("LoginResult succeed(%d), serial(%d)\n", pkt.succeed, pkt.serial);
	}

	virtual void Handle(const Packet::Pkt_SChat& pkt)
	{
		printf("Chat serial(%d) message(%s)\n", pkt.serial, pkt.message.c_str());
	}

	virtual void Handle(const Packet::Pkt_SMyPlayerInfo& pkt)
	{
		printf("MyPlayerInfo serial(%d), name(%s), pos(%.2f, %.2f)\n", 
			pkt.myInfo.serial, pkt.myInfo.name.c_str(), pkt.myInfo.pos.x, pkt.myInfo.pos.y );
	}

	virtual void Handle(const Packet::Pkt_SMovement& pkt)
	{
		printf("Movement serial(%d) src(%.2f, %.2f) dst(%.2f, %.2f)\n", 
			pkt.serial, pkt.src.x, pkt.src.y, pkt.dst.x, pkt.dst.y);
	}

	virtual void Handle(const Packet::Pkt_SOtherPlayerInfo& pkt)
	{
		printf("OtherPlayerListResponse\n");
		for(size_t i=0; i<pkt.list.size(); ++i)
		{
			printf("serial(%d), name(%s), pos(%.2f, %.2f)\n", 
				pkt.list[i].serial,
				pkt.list[i].name.c_str(),
				pkt.list[i].pos.x,
				pkt.list[i].pos.y );
		}
	}
	
	virtual void Handle(const Packet::Pkt_SMonsterInfo& pkt)
	{
		printf("MonsterListResponse\n");
		for(size_t i=0; i<pkt.list.size(); ++i)
		{
			printf("serial(%d), name(%s), class(%s), pos(%.2f, %.2f)\n", 
				pkt.list[i].serial,
				pkt.list[i].name.c_str(),
				pkt.list[i].className.c_str(),
				pkt.list[i].pos.x,
				pkt.list[i].pos.y );
		}
	}
};

CReceiveThread::CReceiveThread() 
	: m_recvOffset(0)
	, m_parseOffset(0)
{
	m_packetBuffer = new char[PacketBufferSize];
}

CReceiveThread::~CReceiveThread()
{
	delete [] m_packetBuffer;
	m_packetBuffer = NULL;
}

void CReceiveThread::Start()
{
	m_threadStopRequest = 0;
	unsigned threadID;
	_beginthreadex( NULL, 0, Run, (void*)this, 0, &threadID);
}

void CReceiveThread::Stop()
{
	m_threadStopRequest = 1;
	while (1 != m_threadFinished)
		Sleep(300);
}

unsigned __stdcall CReceiveThread::Run( void* pv )
{
	CReceiveThread* pTask = (CReceiveThread*)pv;
	pTask->RunImpl();
	_endthreadex( 0 );
	return 0;
}

void CReceiveThread::RunImpl()
{
	m_threadFinished = 0;
	while(0 == m_threadStopRequest)
	{
		Update();
	}
	m_threadFinished = 1;
}


void CReceiveThread::Update()
{
	const int RecviveBufferSize = 1024;
	char receiveBuffer[RecviveBufferSize] = {0,};
	uint32 receivedSize = m_socket->Receive(receiveBuffer, RecviveBufferSize, 1000);
	if (0 == receivedSize)
		return;

	OnRceived(receiveBuffer, receivedSize);
	//printf("Received (%d) bytes\n", receivedSize);
}

void CReceiveThread::SetSocket( CTinyClientSocket* s )
{
	m_socket = s;
}

void CReceiveThread::OnRceived( const char* buffer, uint32 len )
{
	ApplyBuffer(buffer, len);
	TestPacketHandlerImpl handler;
	Packet::ParseServerPacket(handler, m_packetBuffer, m_parseOffset, m_recvOffset);
	if (m_parseOffset == m_recvOffset)
	{
		m_parseOffset = 0;
		m_recvOffset = 0;
	}
}

bool CReceiveThread::ApplyBuffer( const char* buffer, uint32 len )
{
	if ((m_recvOffset+len)>PacketBufferSize)
		return false;

	memcpy(&m_packetBuffer[m_recvOffset], buffer, len);
	m_recvOffset += len;
	return true;
}

#endif 