#pragma once

class CTinyClientSocket;


class CReceiveThread
{
public:
	CReceiveThread(void);
	~CReceiveThread(void);

public:
	void Start();
	void Stop();
	void SetSocket(CTinyClientSocket* s);

protected:
	static unsigned __stdcall	Run(void* pv);

protected:
	void RunImpl();
	void Update();
	void OnRceived(const char* buffer, uint32 len);
	bool ApplyBuffer(const char* buffer, uint32 len);

private:
	volatile long m_threadStopRequest;
	volatile long m_threadFinished;
	CTinyClientSocket* m_socket;
	char* m_packetBuffer;
	int m_recvOffset;
	int m_parseOffset;
};
